package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcpAddressBookInfo //
                implements IWtcpReceivable
{
    public String itemId;
    public String itemDisplayName;
    public String itemType;
    public String itemPhoneNumber;

    public WtcpAddressBookInfo(String itemId, String itemDisplayName, String itemType, String itemPhoneNumber)
    {
        this.itemId = itemId;
        this.itemDisplayName = itemDisplayName;
        this.itemType = itemType;
        this.itemPhoneNumber = itemPhoneNumber;
    }

    public WtcpAddressBookInfo(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    //@Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        itemId = inputStream.readString();
        itemDisplayName = inputStream.readString();
        itemType = inputStream.readString();
        itemPhoneNumber = inputStream.readString();
    }

    //@Override
    public String toString()
    {
        return new StringBuffer() //
        .append('(') //
        .append("id=").append(WtcString.quote(itemId)) //
        .append(", displayName=").append(WtcString.quote(itemDisplayName)) //
        .append(", type=").append(WtcString.quote(itemType)) //
        .append(", phoneNumber=").append(WtcString.quote(itemPhoneNumber)) //
        .append(')') //
        .toString();
    }
}
