package com.twistpair.wave.thinclient.net;

import android.net.Uri;

public class WtcUriPlatform extends WtcUri
{
    public static final WtcUriPlatform EMPTY = new WtcUriPlatform(Uri.EMPTY);

    public static WtcUriPlatform parse(String uriString)
    {
        return new WtcUriPlatform(Uri.parse(WtcUri.escape(uriString)));
    }

    // TODO:(pv) Somehow move this to WtcUri?
    public static boolean isNullOrEmpty(WtcUri[] uris)
    {
        if (uris == null || uris.length == 0)
        {
            return true;
        }
        for (int i = 0; i < uris.length; i++)
        {
            WtcUri uri = uris[i];
            if (uri == null || uri == WtcUriPlatform.EMPTY)
            {
                return true;
            }
        }
        return false;
    }

    private final Uri uri;

    private WtcUriPlatform(Uri uri)
    {
        this.uri = uri;
    }

    public String toString()
    {
        return uri.toString();
    }

    public String getScheme()
    {
        return uri.getScheme();
    }

    public String getHost()
    {
        return uri.getHost();
    }

    public int getPort()
    {
        return uri.getPort();
    }

    public String getPath()
    {
        return uri.getPath();
    }

    public String getQueryParameter(String key)
    {
        return uri.getQueryParameter(key);
    }

    public WtcUri.Builder buildUpon()
    {
        return new Builder(uri.buildUpon());
    }

    public static class Builder extends WtcUri.Builder
    {
        private final android.net.Uri.Builder builder;

        public Builder()
        {
            this(new android.net.Uri.Builder());
        }

        private Builder(android.net.Uri.Builder builder)
        {
            this.builder = builder;
        }

        public WtcUri.Builder scheme(String scheme)
        {
            builder.scheme(scheme);
            return this;
        }

        public WtcUri.Builder authority(String authority)
        {
            builder.authority(authority);
            return this;
        }

        public WtcUri.Builder path(String path)
        {
            builder.path(path);
            return this;
        }

        public WtcUri.Builder appendQueryParameter(String key, String value)
        {
            builder.appendQueryParameter(key, value);
            return this;
        }

        public WtcUri build()
        {
            return new WtcUriPlatform(builder.build());
        }
    }
}
