package com.twistpair.wave.thinclient.net;

import com.twistpair.wave.thinclient.util.WtcString;

public abstract class WtcUri
{
    public static final String URI_SCHEME_HTTP  = "http";
    public static final String URI_SCHEME_HTTPS = "https";

    public static String escape(String uriString)
    {
        uriString = WtcString.replace(uriString, " ", "%20");
        return uriString;
    }

    public static String toString(WtcUri[] uris)
    {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < uris.length; i++)
        {
            if (i > 0)
            {
                sb.append(',');
            }
            sb.append('\"').append(uris[i].toString()).append('\"');
        }
        sb.append(']');
        return sb.toString();
    }

    public abstract String getScheme();

    public abstract String getHost();

    public abstract int getPort();

    public abstract String getPath();

    public abstract String getQueryParameter(String key);

    public abstract Builder buildUpon();

    public static abstract class Builder
    {
        public abstract Builder scheme(String scheme);

        public abstract Builder authority(String authority);

        public abstract Builder path(String path);

        public abstract Builder appendQueryParameter(String key, String value);

        public abstract WtcUri build();
    }
}
