package com.twistpair.wave.thinclient.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import org.w3c.dom.Element;

import com.twistpair.wave.thinclient.WtcLocatorException.WtcLocatorResponseInvalidException;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform.WtcNetworkHostnameNotVerifiedException;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform.WtcNetworkUnknownHostException;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform.WtcNetworkUnreachableException;
import com.twistpair.wave.thinclient.util.WtcXml;
import com.twistpair.wave.thinclient.util.WtcXml.WtcXmlException;

// TODO:(pv) Rename to WtcHttp?
public class WtcNet
{
    private static final String TAG = WtcLog.TAG(WtcNet.class);

    public static class WtcHttpResponseText
    {
        private final int    responseCode;
        private final String response;

        protected WtcHttpResponseText(int responseCode, String response)
        {
            this.responseCode = responseCode;
            this.response = response;
        }

        public int getResponseCode()
        {
            return responseCode;
        }

        public String getResponse()
        {
            return response;
        }
    }

    /**
     * @param uri
     * @return null if the HTTP[S] response is not 200/OK
     * @throws IOException
     * @throws WtcXmlException
     */
    public static Element makeRequestXml(WtcUri uri) throws IOException, WtcLocatorResponseInvalidException
    {
        try
        {
            WtcLog.info(TAG, "+makeRequestXml(" + uri + ")");

            WtcHttpResponseText response = makeRequestText(uri);

            Element xmlDoc = null;

            try
            {
                if (response.getResponseCode() == WtcHttpConnectionPlatform.HTTP_OK)
                {
                    xmlDoc = WtcXml.toXmlDoc(response.response);
                }
            }
            catch (WtcXmlException e)
            {
                throw new WtcLocatorResponseInvalidException(e, response.response);
            }

            return xmlDoc;
        }
        finally
        {
            WtcLog.info(TAG, "+makeRequestXml(" + uri + ")");
        }
    }

    public static WtcHttpResponseText makeRequestText(WtcUri uri) throws IOException
    {
        try
        {
            WtcLog.info(TAG, "+makeRequestText(" + uri + ")");

            while (true)
            {
                WtcLog.info(TAG, "Request: " + uri);

                WtcHttpConnectionPlatform conn;
                try
                {
                    WtcLog.info(TAG, "+WtcConnection.open(uri)");

                    /*
                    // $INJECT: For debugging purposes only...
                    if (true)
                    {
                        //throw new WtcNetworkException.WtcNetworkUnknownHostException(uri, new Exception("pv testing"));
                        //throw new ConnectException("induced for debugging");
                        //throw new ConnectException();//"wtcdev.twistpair.com/75.147.183.61:80 - Network is unreachable");
                    }
                    */

                    conn = (WtcHttpConnectionPlatform) WtcConnection.open(uri);
                    WtcLog.info(TAG, "-WtcConnection.open(uri)");
                }
                catch (IOException e)
                {
                    WtcLog.error(TAG, "EXCEPTION: makeRequestText conn=WtcConnection.open(" + uri + ")", e);
                    throw e;
                }

                // TODO:(pv) Any other connection/socket options to set?
                //conn.setConnectTimeout(WtcConnection.getDefaultConnectTimeout());

                InputStream inputStream;
                try
                {
                    WtcLog.info(TAG, "+conn.openInputStream()");
                    inputStream = conn.openInputStream();
                    WtcLog.info(TAG, "-conn.openInputStream()");
                }
                catch (IOException e)
                {
                    WtcLog.error(TAG, "EXCEPTION: makeRequestText inputStream=conn.openInputStream()", e);
                    if (WtcNetworkExceptionPlatform.isUnreachable(e))
                    {
                        e = new WtcNetworkUnreachableException(uri, e);
                    }
                    else if (WtcNetworkExceptionPlatform.isUnknownHostException(e))
                    {
                        e = new WtcNetworkUnknownHostException(uri, e);
                    }
                    else if (WtcNetworkExceptionPlatform.isHostnameNotVerified(e))
                    {
                        e = new WtcNetworkHostnameNotVerifiedException(uri, e);
                    }
                    throw e;
                }

                // 06-19 16:22:03.626: I/WtcNet(13918): T13992 Request: https://yahoo.com/wave/_interface/proxy_locator.asp?action=getproxy&nonce=-1819596970731120614&version=6.0.0.0
                // 06-19 16:22:05.384: I/WtcNet(13918): T13992 responseCode=301
                // 06-19 16:22:05.403: I/WtcNet(13918): T13992 Response: The document has moved <A HREF="http://yahoo.com/wave/_interface/proxy_locator.asp?s=https&amp;action=getproxy&amp;nonce=-1819596970731120614&amp;version=6.0.0.0">here</A>.<P>

                int responseCode = conn.getResponseCode();
                WtcLog.info(TAG, "responseCode=" + responseCode);

                // Log the response XML
                Reader reader = new InputStreamReader(inputStream);
                StringBuffer sb = new StringBuffer();
                int charsRead;
                char[] buffer = new char[1024];

                try
                {
                    while ((charsRead = reader.read(buffer)) > 0)
                    {
                        sb.append(new String(buffer, 0, charsRead));
                    }
                }
                catch (IOException e)
                {
                    WtcLog.error(TAG, "EXCEPTION: makeRequestText reader.read(...)", e);
                    throw e;
                }
                finally
                {
                    reader.close();
                    conn.close();
                }

                String response = sb.toString();

                WtcLog.info(TAG, "Response: " + response);

                switch (responseCode)
                {
                    case WtcHttpConnectionPlatform.HTTP_MOVED_PERM:
                    case WtcHttpConnectionPlatform.HTTP_FOUND: // See http://en.wikipedia.org/wiki/HTTP_302
                    case WtcHttpConnectionPlatform.HTTP_MOVED_TEMP:
                        // Manually follow redirects (if the platform did not auto-follow)
                        String location = conn.getHeaderField("location");
                        if (location == null)
                        {
                            throw new IOException("Missing \"location\" redirect header");
                        }
                        uri = WtcUriPlatform.parse(location);
                        continue;
                    default:
                        if (WtcHttpConnectionPlatform.HTTP_OK != responseCode)
                        {
                            WtcLog.warn(TAG, "Unknown HTTP response. responseCode=" + responseCode
                                            + "; returning response anyway.");
                        }
                        return new WtcHttpResponseText(responseCode, response);
                }
            }
        }
        finally
        {
            WtcLog.info(TAG, "-makeRequestText(" + uri + ")");
        }
    }
}
