package com.twistpair.wave.thinclient.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;

import com.twistpair.wave.thinclient.logging.WtcLog;

public class WtcHttpConnectionPlatform extends WtcConnection
{
    private static final String       TAG             = WtcLog.TAG(WtcHttpConnectionPlatform.class);

    public static final int           HTTP_OK         = HttpURLConnection.HTTP_OK;
    public static final int           HTTP_MOVED_PERM = HttpURLConnection.HTTP_MOVED_PERM;
    public static final int           HTTP_FOUND      = 302;
    public static final int           HTTP_MOVED_TEMP = 307;

    protected final HttpURLConnection connection;

    protected WtcHttpConnectionPlatform(WtcUri uri) throws IOException
    {
        URL url = new URL(uri.toString());
        connection = (HttpURLConnection) url.openConnection();
        connection.setInstanceFollowRedirects(true);
        setConnectTimeout(WtcConnection.getDefaultConnectTimeout());
    }

    public InputStream openInputStream() throws IOException
    {
        return connection.getInputStream();
    }

    public void close() throws IOException
    {
        // ignore; there is no URLConnection.close() in Android
    }

    public void setConnectTimeout(int timeout) throws IllegalArgumentException
    {
        WtcLog.info(TAG, "+setConnectTimeout(" + timeout + ')');
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        WtcLog.info(TAG, "-setConnectTimeout(" + timeout + ')');
    }

    public void setRequestMethod(String method) throws ProtocolException
    {
        connection.setRequestMethod(method);
    }

    public void setDoOutput(boolean newValue)
    {
        connection.setDoOutput(newValue);
    }

    public void connect() throws IOException
    {
        connection.connect();
    }

    public int getResponseCode() throws IOException
    {
        return connection.getResponseCode();
    }

    public String getResponseMessage() throws IOException
    {
        return connection.getResponseMessage();
    }

    public int getContentLength()
    {
        return connection.getContentLength();
    }

    public String getHeaderField(String key)
    {
        return connection.getHeaderField(key);
    }
}
