package com.twistpair.wave.thinclient.media;

import android.media.AudioFormat;
import android.media.AudioManager;

import com.twistpair.wave.thinclient.logging.WtcLog;

public class WtcMediaDeviceSpeakerPlatform //
                extends WtcMediaDeviceSpeaker
{
    private static final String TAG                          = WtcLog.TAG(WtcMediaDeviceSpeakerPlatform.class);

    private final Object        mSyncState                   = new Object();

    private static final int    AUDIO_PLAYER_SAMPLE_RATE     = 8000;
    private static final int    AUDIO_PLAYER_CHANNEL_CONFIG  = AudioFormat.CHANNEL_OUT_MONO;
    private static final int    AUDIO_PLAYER_ENCODING_FORMAT = AudioFormat.ENCODING_PCM_16BIT;

    private int                 mStreamType;
    private Thread              mThreadAudioPlayer;

    //private IWtcMediaSpeakerBufferListener2 mAudioPlayerBufferListener;

    public WtcMediaDeviceSpeakerPlatform(WtcMediaCodec mediaDecoder)
    {
        setMediaDecoder(mediaDecoder);

        mStreamType = AudioManager.STREAM_MUSIC;

        try
        {
            // This is just for sanity that there are no problems while we are starting up.
            // Some devices, especially Motorolas, can fail to open any AudioTrack.
            // This will be done again in the actual AudioPlayBack thread.
            int streamType = getStreamType();
            AudioPlayer.findMinBufferSizeInBytes(streamType, //
                            AUDIO_PLAYER_SAMPLE_RATE, AUDIO_PLAYER_CHANNEL_CONFIG, AUDIO_PLAYER_ENCODING_FORMAT, //
                            10);
        }
        catch (IllegalArgumentException e)
        {
            WtcLog.error(TAG, "Error calculating speaker buffer size", e);
            throw e;
        }
    }

    /**
     * @return One of AudioManager.STREAM_*
     */
    public int getStreamType()
    {
        return mStreamType;
    }

    /**
     * @param streamType One of AudioManager.STREAM_*
     */
    /*
    public void setStreamType(int streamType)
    {
        if (streamType != mStreamType)
        {
            mStreamType = streamType;

            // TODO:(pv) Reset mThreadAudioPlayer...
        }
    }
    */

    /**
     * 
     */
    @Override
    public void setVolume(int volume)
    {
        // ignore; let the volume rocker handle this
        //int streamType = getStreamType();
        //mAudioManager.setStreamVolume(streamType, volume, 0);
    }

    @Override
    public int getVolume()
    {
        // ignore; let the volume rocker handle this
        return -1; // fake full volume
        //int streamType = getStreamType();
        //return mAudioManager.getStreamVolume(streamType);
    }

    @Override
    public boolean isOpen()
    {
        synchronized (mSyncState)
        {
            return mThreadAudioPlayer != null && mThreadAudioPlayer.isAlive();
        }
    }

    @Override
    protected void open() //
                    throws WtcMediaExceptionPlatform
    {
        try
        {
            WtcLog.debug(TAG, "+open()");

            synchronized (mSyncState)
            {
                super.open();

                // AudioPlayer will self close when there is no data, so no need to save a reference 
                AudioPlayer audioPlayer = new AudioPlayer(mStreamType, //
                                AUDIO_PLAYER_SAMPLE_RATE, AUDIO_PLAYER_CHANNEL_CONFIG, AUDIO_PLAYER_ENCODING_FORMAT)
                {
                    @Override
                    protected void onAudioPlayerStarted(int bufferLength)
                    {
                        // ignore?
                    }

                    @Override
                    protected void onAudioPlayerStopped(Exception error)
                    {
                        close(error != null);
                    }

                    @Override
                    protected int onAudioPlayerGetBuffer(short[] buffer) throws InterruptedException
                    {
                        int shortsDecoded = dequeueDecoded(buffer);
                        if (shortsDecoded == -1)
                        {
                            WtcLog.warn(TAG, "dequeueDecoded timeout (>" + getAutoCloseTimeout() + "ms)");
                            shortsDecoded = 0;
                        }
                        return shortsDecoded;
                    }
                };

                mThreadAudioPlayer = new Thread(audioPlayer, "AudioPlayer");
                mThreadAudioPlayer.start();
            }
        }
        finally
        {
            WtcLog.debug(TAG, "-open()");
        }
    }

    @Override
    public void close(boolean error)
    {
        try
        {
            WtcLog.debug(TAG, "+close(error=" + error + ")");

            synchronized (mSyncState)
            {
                if (mThreadAudioPlayer != null)
                {
                    mThreadAudioPlayer.interrupt();
                    mThreadAudioPlayer = null;
                }

                super.close(error);
            }
        }
        finally
        {
            WtcLog.debug(TAG, "-close(error=" + error + ")");
        }
    }
}
