package com.twistpair.wave.thinclient.media;

import android.media.AudioFormat;
import android.media.MediaRecorder;

import com.twistpair.wave.thinclient.WtcDebug;
import com.twistpair.wave.thinclient.logging.WtcLog;

public class WtcMediaDeviceMicrophonePlatform //
                extends WtcMediaDeviceMicrophone //
{
    private static final String  TAG                            = WtcLog.TAG(WtcMediaDeviceMicrophonePlatform.class);

    @SuppressWarnings("unused")
    private static final boolean DBG                            = (WtcDebug.DBG_LEVEL >= 1);
    private static final boolean VDBG                           = (WtcDebug.DBG_LEVEL >= 2);

    private static final int     AUDIO_RECORDER_SAMPLE_RATE     = 8000;
    private static final int     AUDIO_RECORDER_CHANNEL_CONFIG  = AudioFormat.CHANNEL_IN_MONO;
    private static final int     AUDIO_RECORDER_ENCODING_FORMAT = AudioFormat.ENCODING_PCM_16BIT;

    private int                  mAudioSource;
    private AudioRecorder        mAudioRecorder;
    private Thread               mThreadAudioRecorder;
    private boolean              mIsOpening;

    public WtcMediaDeviceMicrophonePlatform(WtcMediaCodec mediaEncoder)
    {
        setMediaEncoder(mediaEncoder);

        mAudioSource = MediaRecorder.AudioSource.MIC;

        try
        {
            // This is just for sanity that there are no problems while we are starting up.
            // Some devices, especially Motorolas, can fail to open any AudioTrack.
            // This will be done again in the actual AudioPlayBack thread.            
            AudioRecorder.findMinBufferSizeInBytes(mAudioSource, //
                            AUDIO_RECORDER_SAMPLE_RATE, AUDIO_RECORDER_CHANNEL_CONFIG, AUDIO_RECORDER_ENCODING_FORMAT, //
                            10);
        }
        catch (IllegalArgumentException e)
        {
            WtcLog.error(TAG, "Error calculating microphone buffer size", e);
            throw e;
        }
    }

    /**
     * @return One of MediaRecorder.AudioSource.*
     */
    public int getAudioSource()
    {
        return mAudioSource;
    }

    /**
     * @param streamType One of MediaRecorder.AudioSource.*
     */
    /*
    public void setAudioSource(int audioSource)
    {
        if (audioSource != mAudioSource)
        {
            mAudioSource = audioSource;

            // TODO:(pv) Reset mThreadAudioRecorder...
        }
    }
    */

    /**
     * 
     */
    @Override
    public void setLevel(int level)
    {
        // ignore for now; currently only record full volume from mic
        // TODO:(pv) Is there any way to set mic volume?
    }

    @Override
    public int getLevel()
    {
        // ignore for now; currently only record full volume from mic
        // TODO:(pv) Is there any way to get mic volume?
        return -1; // fake full volume
    }

    @Override
    public boolean isOpen()
    {
        synchronized (mSyncState)
        {
            return mThreadAudioRecorder != null && mThreadAudioRecorder.isAlive();
        }
    }

    @Override
    public boolean open(Runnable runAfterOpened)
    {
        try
        {
            WtcLog.debug(TAG, "+open(runAfterOpened=" + runAfterOpened + ')');

            synchronized (mSyncState)
            {
                if (super.open(runAfterOpened))
                {
                    return true;
                }

                int codecBytesPerAudioFrame = mMediaEncoder.getBytesPerFrame();

                mAudioRecorder = new AudioRecorder(mAudioSource, //
                                AUDIO_RECORDER_SAMPLE_RATE, AUDIO_RECORDER_CHANNEL_CONFIG, AUDIO_RECORDER_ENCODING_FORMAT, //
                                codecBytesPerAudioFrame)
                {
                    byte[] bufferEncoded;

                    @Override
                    protected void onAudioRecorderStarted(int bufferLength)
                    {
                        bufferEncoded = new byte[bufferLength];
                        onMicrophoneOpened();
                    }

                    @Override
                    protected void onAudioRecorderStopped(Exception error)
                    {
                        super.onAudioRecorderStopped(error);

                        onMicrophoneClosed(error != null);
                        bufferEncoded = null;
                    }

                    @Override
                    protected int onAudioRecorderGotBuffer(short[] bufferUnencoded, int offsetUnencoded, int lengthUnencoded)
                                    throws InterruptedException
                    {
                        if (VDBG)
                        {
                            WtcLog.info(TAG, "+encode(...)");
                        }
                        int lengthEncoded = encode(bufferUnencoded, offsetUnencoded, lengthUnencoded, bufferEncoded);
                        if (VDBG)
                        {
                            WtcLog.info(TAG, "-encode(...); lengthEncoded=" + lengthEncoded);
                        }

                        if (lengthEncoded > 0)
                        {
                            if (VDBG)
                            {
                                WtcLog.info(TAG, "+onMicrophoneBuffer(...)");
                            }
                            onMicrophoneBuffer(bufferEncoded, 0, lengthEncoded);
                            if (VDBG)
                            {
                                WtcLog.info(TAG, "-onMicrophoneBuffer(...)");
                            }
                        }
                        else
                        {
                            WtcLog.warn(TAG, "encode(...) returned 0 bytes");
                        }

                        return lengthEncoded;
                    }
                };

                mThreadAudioRecorder = new Thread(mAudioRecorder, "AudioRecorder");
                WtcLog.debug(TAG, "+mThreadAudioRecorder.start()");
                mThreadAudioRecorder.start();
                WtcLog.debug(TAG, "-mThreadAudioRecorder.start()");

                mIsOpening = true;

                return false;
            }
        }
        finally
        {
            WtcLog.debug(TAG, "-open(runAfterOpened=" + runAfterOpened + ')');
        }
    }

    @Override
    public boolean close(boolean error, Runnable runAfterClosed)
    {
        String sig = "close(error=" + error + ", runAfterClosed=" + runAfterClosed + ')';

        try
        {
            if (error)
            {
                WtcLog.error(TAG, "+" + sig);
            }
            else
            {
                WtcLog.debug(TAG, "+" + sig);
            }

            synchronized (mSyncState)
            {
                // TODO:(pv) Empty the buffers?!?!?

                if (super.close(error, runAfterClosed) && !mIsOpening)
                {
                    return true;
                }

                if (mAudioRecorder != null)
                {
                    WtcLog.debug(TAG, "+mAudioRecorder.stop()");
                    mAudioRecorder.stop();
                    WtcLog.debug(TAG, "-mAudioRecorder.stop()");

                    mAudioRecorder = null;
                }

                if (mThreadAudioRecorder != null)
                {
                    WtcLog.debug(TAG, "+mThreadAudioRecorder.interrupt()");
                    mThreadAudioRecorder.interrupt();
                    WtcLog.debug(TAG, "-mThreadAudioRecorder.interrupt()");
                    mThreadAudioRecorder = null;
                }

                mIsOpening = false;

                return false;
            }
        }
        finally
        {
            if (error)
            {
                WtcLog.error(TAG, "-" + sig);
            }
            else
            {
                WtcLog.debug(TAG, "-" + sig);
            }
        }
    }
}
