package com.twistpair.wave.thinclient.media;

public class WtcMediaCodecRawCopy extends WtcMediaCodec
{
    private static final String LIB_NAME = "RawCopy";

    public String getName()
    {
        return LIB_NAME;
    }

    public int getSampleRate()
    {
        return 8000;
    }

    public int getMillisecondsPerFrame()
    {
        return 20;
    }

    public int getByteCountForDuration(int duration, int minbuffSize)
    {
        return minbuffSize / 2;
    }

    public int getBytesPerFrame()
    {
        return 320; // 640?
    }

    protected boolean initialize()
    {
        return true;
    }

    public void close()
    {
    }

    public int decode(byte[] bufferEncoded, int length, short[] bufferUnencoded)
    {
        int lengthUnencoded = 0;
        for (int i = 0; i < length; i += 2)
        {
            bufferUnencoded[lengthUnencoded++] = (short) ((bufferEncoded[i + 1] << 8) | (bufferEncoded[i] & 0xff));
        }
        return lengthUnencoded;
    }

    public int encode(short[] bufferUnencoded, int offset, int length, byte[] bufferEncoded)
    {
        int lengthEncoded = 0;
        int offsetLength = offset + length;
        for (int i = offset; i < offsetLength; i++)
        {
            bufferEncoded[lengthEncoded++] = (byte) (bufferUnencoded[i] & 0xff);
            bufferEncoded[lengthEncoded++] = (byte) ((bufferUnencoded[i] >> 8) & 0xff);
        }
        return lengthEncoded;
    }
}