package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.logging.WtcLog;

public class WtcMediaCodecAmrPlatform extends WtcMediaCodecRawCopy
{
    private static final String TAG = WtcLog.TAG(WtcMediaCodecAmrPlatform.class);

    public String getName()
    {
        return TAG;
    }

    public int getSampleRate()
    {
        return 8000;
    }

    public int getMillisecondsPerFrame()
    {
        return 20;
    }

    public int getByteCountForDuration(int duration, int minbuffSize)
    {
        return minbuffSize / 2;
    }

    public int getBytesPerFrame()
    {
        return 320; // 640?
    }

    protected boolean initialize()
    {
        return true;
    }

    public void close()
    {
    }
}