package com.twistpair.wave.thinclient.media;

import com.twistpair.wave.thinclient.logging.WtcLog;

/**
 * Provides interface to GSM codec implemented in JNI lib.
 * The code is the standard GSM codec.
 * The native code has been optimized as much as possible. 
 */
public class GSMCodec extends Codec
{
    private static final String TAG      = WtcLog.TAG(GSMCodec.class);

    private static final String LIB_NAME = "GSM";
    private static final String LIB_PATH = "gsmlib";

    private native int InitLib();

    private native int Close();

    private native int Decode(byte[] bufferEncoded, int lengthEncoded, //
                    short[] bufferUnencoded, int lengthUnencoded);

    private native int Encode(short[] bufferUnencoded, int offsetUnencoded, int lengthUnencoded, //
                    byte[] bufferEncoded, int lengthEncoded);

    public GSMCodec()
    {
        initialize();
    }

    @Override
    public String getName()
    {
        return LIB_NAME;
    }

    protected static boolean isInitialized = false;

    public boolean initialize()
    {
        if (loadLibrary(LIB_PATH) && !isInitialized)
        {
            try
            {
                isInitialized = (InitLib() == 1);
            }
            catch (Exception ex)
            {
                WtcLog.error(TAG, "EXCEPTION: Could not initialize " + LIB_PATH + " lib", ex);
            }
        }
        return isInitialized;
    }

    public void close()
    {
        if (!isInitialized)
            return;

        Close();

        isInitialized = false;
    }

    // TODO:(pv) Consider optimizing JNI Encode/Decode by using "DirectBufferAddress"
    // http://stackoverflow.com/questions/8528179/android-most-efficient-way-to-pass-some-read-only-bytes-to-native-c
    // http://stackoverflow.com/questions/5670862/bytebuffer-allocate-vs-bytebuffer-allocatedirect
    // http://elliotth.blogspot.com/2007/03/optimizing-jni-array-access.html
    // http://comments.gmane.org/gmane.comp.handhelds.android.ndk/11476
    // http://java.sun.com/docs/books/jni/html/objtypes.html#27346
    // http://java.sun.com/docs/books/jni/html/functions.html#100890

    public int encode(short[] bufferUnencoded, int offset, int length, byte[] bufferEncoded)
    {
        if (!isInitialized)
            return 0;

        //WtcLog.info(TAG, "Encode length[Unencoded]=" + length);
        //int lengthEncoded = 
        return Encode(bufferUnencoded, offset, length, bufferEncoded, bufferEncoded.length);
        //WtcLog.info(TAG, "Encode lengthEncoded=" + lengthEncoded);
        //return lengthEncoded;
    }

    public int decode(byte[] bufferEncoded, int length, short[] bufferUnencoded)
    {
        if (!isInitialized)
            return 0;

        //setFirstPacket();

        //WtcLog.info(TAG, "Decode length[Encoded]=" + length);
        //int lengthDecoded = 
        return Decode(bufferEncoded, length, bufferUnencoded, bufferUnencoded.length);
        //WtcLog.info(TAG, "Decode lengthDecoded=" + lengthDecoded);
    }
}
