package com.twistpair.wave.thinclient.logging;

import java.util.Vector;

import com.twistpair.wave.thinclient.util.WtcString;

/**
 * 
 * @author pv
 * 
 *         Roughly parallels Android's Log static class:
 *         http://hi-android.info/src/android/util/Log.java.html
 * 
 */
public class WtcLog
{
    public static String TAG(Object o)
    {
        return TAG((o == null) ? null : o.getClass());
    }

    public static String TAG(Class c)
    {
        return WtcString.getShortClassName(c);
    }

    private static boolean isEnabled = true;

    public static void isEnabled(boolean enable)
    {
        isEnabled = enable;
    }

    public static boolean isEnabled()
    {
        return isEnabled;
    }

    // TODO:(pv) Set logging level?

    private static final Vector logListeners = new Vector();

    public static void addListener(IWtcLogListener listener)
    {
        synchronized (logListeners)
        {
            logListeners.addElement(listener);
        }
    }

    public static void removeListener(IWtcLogListener listener)
    {
        synchronized (logListeners)
        {
            logListeners.removeElement(listener);
        }
    }

    public static void clearListeners()
    {
        synchronized (logListeners)
        {
            logListeners.removeAllElements();
        }
    }

    protected static void println(String tag, int level, String msg, Throwable e)
    {
        if (isEnabled)// && WtcLogPlatform.isLoggable(tag, level))
        {
            String preformatted = WtcLogPlatform.println(tag, level, msg, e);
            if (logListeners.size() > 0)
            {
                synchronized (logListeners)
                {
                    for (int i = 0; i < logListeners.size(); i++)
                    {
                        if (preformatted != null)
                        {
                            ((IWtcLogListener) logListeners.elementAt(i)).println(preformatted);
                        }
                        else
                        {
                            ((IWtcLogListener) logListeners.elementAt(i)).println(tag, level, msg, e);
                        }
                    }
                }
            }
        }
    }

    public static void verbose(String tag, String msg)
    {
        verbose(tag, msg, null);
    }

    public static void verbose(String tag, Throwable e)
    {
        verbose(tag, "Throwable", e);
    }

    public static void verbose(String tag, String msg, Throwable e)
    {
        println(tag, WtcLogPlatform.VERBOSE, msg, e);
    }

    public static void debug(String tag, String msg)
    {
        debug(tag, msg, null);
    }

    public static void debug(String tag, Throwable e)
    {
        debug(tag, "Throwable", e);
    }

    public static void debug(String tag, String msg, Throwable e)
    {
        println(tag, WtcLogPlatform.DEBUG, msg, e);
    }

    public static void info(String tag, String msg)
    {
        info(tag, msg, null);
    }

    public static void info(String tag, Throwable e)
    {
        info(tag, "Throwable", e);
    }

    public static void info(String tag, String msg, Throwable e)
    {
        println(tag, WtcLogPlatform.INFO, msg, e);
    }

    public static void warn(String tag, String msg)
    {
        warn(tag, msg, null);
    }

    public static void warn(String tag, Throwable e)
    {
        warn(tag, "Throwable", e);
    }

    public static void warn(String tag, String msg, Throwable e)
    {
        println(tag, WtcLogPlatform.WARN, msg, e);
    }

    public static void error(String tag, String msg)
    {
        error(tag, msg, null);
    }

    public static void error(String tag, Throwable e)
    {
        error(tag, "Throwable", e);
    }

    public static void error(String tag, String msg, Throwable e)
    {
        println(tag, WtcLogPlatform.ERROR, msg, e);
    }

    public static void fatal(String tag, String msg)
    {
        fatal(tag, msg, null);
    }

    public static void fatal(String tag, Throwable e)
    {
        fatal(tag, "Throwable", e);
    }

    public static void fatal(String tag, String msg, Throwable e)
    {
        println(tag, WtcLogPlatform.FATAL, msg, e);
    }
}
