package com.twistpair.wave.thinclient;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.twistpair.wave.thinclient.WtcLocatorException.WtcLocatorResponseInvalidException;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcLocatorResponse
{
    private static final String TAG = WtcLog.TAG(WtcLocator.class);

    public final int            errorCode;
    public final WtcProxyInfo[] proxyInfos;

    public WtcLocatorResponse(Element element) throws WtcLocatorResponseInvalidException
    {
        if (element == null)
        {
            throw new WtcLocatorResponseInvalidException("XML is null/empty", element);
        }

        String tagName = element.getTagName();
        if (!tagName.equals("ServerResponse"))
        {
            throw new WtcLocatorResponseInvalidException("XML root node name is not \"ServerResponse\"", element);
        }

        String error = element.getAttribute("Error");
        if (WtcString.isNullOrEmpty(error))
        {
            throw new WtcLocatorResponseInvalidException("ServerResponse node has no \"Error\" attribute", element);
        }

        // DEBUG: Used to fake a response; for debug purposes only
        //error = String.valueOf(WtcLocatorErrorCodes.NoProxyFound);

        errorCode = Integer.parseInt(error);

        NodeList proxyNodes = element.getElementsByTagName("Proxy");
        if (proxyNodes == null)
        {
            if (errorCode == WtcLocatorErrorCodes.OK)
            {
                throw new WtcLocatorResponseInvalidException("ServerResponse node has no \"Proxy\" child node(s)", element);
            }

            proxyInfos = new WtcProxyInfo[0];
        }
        else
        {
            int proxyCount = proxyNodes.getLength();
            proxyInfos = new WtcProxyInfo[proxyCount];
            for (int i = 0; i < proxyCount; i++)
            {
                Node proxyNode = proxyNodes.item(i);
                proxyInfos[i] = new WtcProxyInfo(proxyNode);
            }
        }
    }

    public boolean isOK()
    {
        return WtcLocatorErrorCodes.isOK(errorCode) && proxyInfos != null && proxyInfos.length > 0;
    }

    public boolean isError()
    {
        return !isOK();
    }

    public String toString()
    {
        return "WtcLocatorResponse [errorCode=" + WtcLocatorErrorCodes.toString(errorCode) //
                        + ", proxyInfos=" + WtcProxyInfo.toString(proxyInfos) + "]";
    }
}
