package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.util.WtcString;

public class WtcLocatorErrorCodes
{
    public static final int OK                     = 0;
    public static final int ActionNotSupported     = 1;
    public static final int NoProxyFound           = 2;
    public static final int UnsupportedPackageCode = 3;

    public static boolean isOK(int errorCode)
    {
        return errorCode == OK;
    }

    public static boolean isError(int errorCode)
    {
        return errorCode != OK;
    }

    public static String getName(int errorCode)
    {
        switch (errorCode)
        {
            case OK:
                return "OK";
            case ActionNotSupported:
                return "Action Not Supported";
            case NoProxyFound:
                return "No Proxy Found";
            case UnsupportedPackageCode:
                return "Unsupported Package Code";
            default:
                return "?";
        }
    }

    public static String toString(int errorCode)
    {
        return toString(errorCode, 'd');
    }

    public static String toString(int errorCode, char format)
    {
        switch (format)
        {
            case 'd':
                return '\"' + getName(errorCode) + "\"(" + WtcString.formatNumber(errorCode, 1) + ')';
            default:
                return '\"' + getName(errorCode) + "\"(0x" + WtcString.toHexString(errorCode, 1) + ')';
        }
    }
}
