/*
 * Decompiled with CFR 0.152.
 */
package com.twistedequations.rxintent.internal;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.Intent;
import android.os.Bundle;
import com.twistedequations.rxintent.RxIntentResult;
import com.twistedequations.rxintent.internal.PreConditions;
import com.twistedequations.rxintent.internal.RxIntentFragment;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action3;
import rx.subscriptions.BooleanSubscription;

public class RxIntentObserveOnSubscribe
implements Observable.OnSubscribe<RxIntentResult> {
    private final Activity activity;
    private final int requestCode;

    public RxIntentObserveOnSubscribe(Activity activity, int requestCode) {
        this.activity = activity;
        this.requestCode = requestCode;
        PreConditions.throwIfNotOnMainThread();
    }

    public void call(final Subscriber<? super RxIntentResult> subscriber) {
        PreConditions.throwIfNotOnMainThread();
        final FragmentManager fragmentManager = this.activity.getFragmentManager();
        Action3<Integer, Integer, Intent> callback = new Action3<Integer, Integer, Intent>(){

            public void call(Integer requestCode, Integer resultCode, Intent intent) {
                if (!subscriber.isUnsubscribed()) {
                    subscriber.onNext((Object)RxIntentResult.create(intent, resultCode));
                }
            }
        };
        Action0 removeCallbackFunc = new Action0((Action3)callback){
            final /* synthetic */ Action3 val$callback;
            {
                this.val$callback = action3;
            }

            public void call() {
                Fragment fragment = fragmentManager.findFragmentByTag(RxIntentObserveOnSubscribe.fragmentTag(RxIntentObserveOnSubscribe.this.requestCode));
                if (fragment != null) {
                    ((RxIntentFragment)((Object)RxIntentFragment.class.cast(fragment))).removeCallback((Action3<Integer, Integer, Intent>)this.val$callback);
                }
            }
        };
        subscriber.add((Subscription)BooleanSubscription.create((Action0)removeCallbackFunc));
        RxIntentObserveOnSubscribe.getFragment(this.activity, this.requestCode).addCallback(callback);
    }

    public static void start(Activity activity, Intent intent, Bundle options, int requestCode) {
        PreConditions.throwIfNotOnMainThread();
        RxIntentObserveOnSubscribe.getFragment(activity, requestCode).setStartData(intent, options, requestCode);
    }

    private static RxIntentFragment getFragment(Activity activity, int requestCode) {
        RxIntentFragment intentFragment;
        FragmentManager fragmentManager = activity.getFragmentManager();
        Fragment fragment = fragmentManager.findFragmentByTag(RxIntentObserveOnSubscribe.fragmentTag(requestCode));
        if (fragment == null) {
            intentFragment = new RxIntentFragment();
            fragmentManager.beginTransaction().add((Fragment)intentFragment, RxIntentObserveOnSubscribe.fragmentTag(requestCode)).commitAllowingStateLoss();
        } else {
            intentFragment = (RxIntentFragment)fragment;
        }
        return intentFragment;
    }

    private static String fragmentTag(int requestCode) {
        return "RxIntentFragment" + requestCode;
    }
}

