/*
 * Decompiled with CFR 0.152.
 */
package com.twistedequations.rxintent.internal;

import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import java.util.HashSet;
import java.util.Set;
import rx.functions.Action3;

public class RxIntentFragment
extends Fragment {
    static final String FRAGMENT_TAG = "RxIntentFragment";
    private Intent intent;
    private int requestCode;
    private Bundle options;
    private final Set<Action3<Integer, Integer, Intent>> callbacks = new HashSet<Action3<Integer, Integer, Intent>>();
    private boolean pending = false;

    public void setStartData(Intent intent, Bundle options, int requestCode) {
        this.intent = intent;
        this.requestCode = requestCode;
        this.options = options;
        if (!this.isDetached()) {
            this.internalStartActivity();
        } else {
            this.pending = true;
        }
    }

    public void addCallback(Action3<Integer, Integer, Intent> callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Action3<Integer, Integer, Intent> callback) {
        this.callbacks.remove(callback);
    }

    private void internalStartActivity() {
        if (Build.VERSION.SDK_INT >= 16 && this.options != null) {
            this.startActivityForResult(this.intent, this.requestCode, this.options);
        } else {
            this.startActivityForResult(this.intent, this.requestCode);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.pending) {
            this.pending = false;
            this.internalStartActivity();
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.requestCode = savedInstanceState.getInt("requestCode");
            this.options = savedInstanceState.getBundle("options");
            this.intent = (Intent)savedInstanceState.getParcelable("intent");
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == this.requestCode) {
            HashSet<Action3<Integer, Integer, Intent>> callbacks = new HashSet<Action3<Integer, Integer, Intent>>(this.callbacks);
            for (Action3 action3 : callbacks) {
                action3.call((Object)requestCode, (Object)resultCode, (Object)data);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable("intent", (Parcelable)this.intent);
        outState.putBundle("options", this.options);
        outState.putInt("requestCode", this.requestCode);
    }
}

