/*
 * Decompiled with CFR 0.152.
 */
package com.twistedequations.rx;

import com.twistedequations.rx.AndroidRxSchedulers;
import com.twistedequations.rx.internal.AndroidThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import rx.Scheduler;
import rx.android.schedulers.AndroidSchedulers;
import rx.schedulers.Schedulers;

public class DefaultAndroidRxSchedulers
implements AndroidRxSchedulers {
    private static final int PROCESSOR_THREADS = Math.max(2, Runtime.getRuntime().availableProcessors());
    private static final int NETWORK_THREADS = 6;
    private static final int IO_THREADS = 6;
    private static final Scheduler NETWORK_EXECUTOR = Schedulers.from((Executor)Executors.newFixedThreadPool(6, new AndroidThreadFactory("network")));
    private static final Scheduler IO_SCHEDULER = Schedulers.from((Executor)Executors.newFixedThreadPool(6, new AndroidThreadFactory("i/o")));
    private static final Scheduler COMPUTATION_SCHEDULER = Schedulers.from((Executor)Executors.newFixedThreadPool(PROCESSOR_THREADS, new AndroidThreadFactory("computation")));

    @Override
    public Scheduler network() {
        return NETWORK_EXECUTOR;
    }

    @Override
    public Scheduler io() {
        return IO_SCHEDULER;
    }

    @Override
    public Scheduler computation() {
        return COMPUTATION_SCHEDULER;
    }

    @Override
    public Scheduler newThread() {
        return Schedulers.from((Executor)Executors.newSingleThreadExecutor(new AndroidThreadFactory("newThread")));
    }

    @Override
    public Scheduler immediate() {
        return Schedulers.from((Executor)Executors.newFixedThreadPool(6, new AndroidThreadFactory("network")));
    }

    @Override
    public Scheduler mainThread() {
        return AndroidSchedulers.mainThread();
    }
}

