/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class Utils {
    Utils() {
    }

    static Handler createHandler() {
        Handler handler = null;
        Looper looper = Looper.myLooper();
        if (looper != null) {
            handler = new Handler(looper);
        } else {
            looper = Looper.getMainLooper();
            if (looper != null) {
                handler = new Handler(looper);
            }
        }
        if (handler == null) {
            throw new IllegalThreadStateException("This thread must be able to obtain a Looper");
        }
        return handler;
    }

    static boolean isAudioPermissionGranted(Context context) {
        int MICROPHONE_PERMISSION = context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO");
        return MICROPHONE_PERMISSION == 0;
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    boolean isIPv4;
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress();
                    boolean bl = isIPv4 = sAddr.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr.toUpperCase() : sAddr.substring(0, delim).toUpperCase();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    static boolean permissionGranted(Context context, String permission2) {
        int permissionCheck = context.checkCallingOrSelfPermission(permission2);
        return permissionCheck == 0;
    }

    @Nullable
    static String parseClientIdentity(@Nullable String toField) {
        if (toField != null) {
            return toField.replaceFirst("^client:", "");
        }
        return null;
    }

    static void parseCustomParams(@NonNull String queryPairs, @NonNull Map<String, String> customParameters) {
        String[] pairs;
        for (String pair : pairs = queryPairs.split("&")) {
            int idx = pair.indexOf("=");
            try {
                String key = idx > 0 ? pair.substring(0, idx) : pair;
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1).replaceAll("\\+", "%20"), "UTF-8") : null;
                customParameters.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    static Pair<String[], String[]> mapToArrays(Map<String, String> map) {
        Pair keyValueArrays = new Pair((Object)new String[map.size()], (Object)new String[map.size()]);
        int index = 0;
        for (Map.Entry<String, String> mapEntry : map.entrySet()) {
            ((String[])keyValueArrays.first)[index] = mapEntry.getKey();
            ((String[])keyValueArrays.second)[index] = mapEntry.getValue();
            ++index;
        }
        return keyValueArrays;
    }

    static Map<String, String> bundleToMap(Bundle data) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String key : data.keySet()) {
            dataMap.put(key, String.valueOf(data.get(key)));
        }
        return dataMap;
    }

    static void DumpBacktrace() {
        try {
            throw new RuntimeException();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

