/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.annotation.SuppressLint;
import android.content.Context;
import com.twilio.voice.Constants;
import com.twilio.voice.EventMetadata;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

class MetricEvent
extends EventMetadata {
    private JSONArray payload;

    private MetricEvent(Builder builder) {
        this.productName = builder.productName;
        this.level = builder.level;
        this.groupName = builder.groupName;
        this.eventName = builder.eventName;
        this.callSid = builder.callSid;
        this.payloadType = builder.payloadType;
        this.payload = builder.payload;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public JSONObject toJSONObject(Context context) throws Exception {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        this.timeStamp = df.format(new Date());
        JSONObject metricEventJsonObject = this.jsonEnvelopePreparation(this.productName, "metrics-sample", "quality-metrics-samples");
        JSONObject publisherMetadata = this.jsonPublisherMetadataPreparation(context);
        metricEventJsonObject.put("publisher_metadata", (Object)publisherMetadata);
        metricEventJsonObject.put("payload", (Object)this.payload);
        return metricEventJsonObject;
    }

    public void addStatsToPayload(JSONObject samplePayload) {
        if (this.payload == null) {
            this.payload = new JSONArray();
        }
        this.payload.put((Object)samplePayload);
    }

    public JSONArray getPayload() {
        return this.payload;
    }

    public void setPayload(JSONArray jsonArray) {
        this.payload = jsonArray;
    }

    static class Builder {
        private String productName;
        private Constants.SeverityLevel level;
        private String groupName;
        private String eventName;
        private String callSid;
        private String payloadType;
        private JSONArray payload;

        Builder() {
        }

        Builder productName(String productName) {
            this.productName = productName;
            return this;
        }

        Builder level(Constants.SeverityLevel level) {
            this.level = level;
            return this;
        }

        Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        Builder payLoadType(String payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        Builder payLoad(JSONArray metrics) {
            this.payload = metrics;
            return this;
        }

        MetricEvent build() {
            if (this.productName == null) {
                throw new NullPointerException("productName must not be null");
            }
            if (this.level == null) {
                throw new NullPointerException("level must not be null");
            }
            if (this.groupName == null) {
                throw new NullPointerException("groupName must not be null");
            }
            if (this.eventName == null) {
                throw new NullPointerException("eventName must not be null");
            }
            if (this.payloadType == null) {
                throw new NullPointerException("payloadType must not be null");
            }
            return new MetricEvent(this);
        }
    }
}

