/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.LogLevel;
import com.twilio.voice.LogModule;
import com.twilio.voice.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class LogParameters {
    @NonNull
    public LogModule module;
    @NonNull
    public LogLevel level;
    @NonNull
    public String timestamp;
    @NonNull
    public String file;
    @NonNull
    public String function;
    public int line;
    @NonNull
    public String tag;
    @NonNull
    public String message;
    @NonNull
    public String thread;
    @Nullable
    public Throwable tr;

    private LogParameters(@NonNull Builder builder) {
        Preconditions.checkNotNull(builder, "Builder must not be null");
        this.module = builder.module;
        this.level = builder.level;
        this.timestamp = builder.timestamp;
        this.file = builder.file;
        this.function = builder.function;
        this.line = builder.line;
        this.tag = builder.tag;
        this.message = builder.message;
        this.thread = builder.thread;
        this.tr = builder.tr;
    }

    public LogParameters(@NonNull LogModule module, @NonNull LogLevel level, @NonNull String timestamp, @NonNull String file, @NonNull String function, int line, @NonNull String tag, @NonNull String message, @NonNull String thread) {
        Preconditions.checkNotNull(module, "Module must not be null");
        Preconditions.checkNotNull(level, "Level must not be null");
        Preconditions.checkNotNull(timestamp, "Timestamp must not be null");
        Preconditions.checkNotNull(file, "Filename must not be null");
        Preconditions.checkNotNull(function, "Method name must not be null");
        Preconditions.checkNotNull(tag, "Tag must not be null");
        Preconditions.checkNotNull(message, "Message must not be null");
        Preconditions.checkNotNull(thread, "Thread name or id must not be null");
        this.module = module;
        this.level = level;
        this.timestamp = timestamp.isEmpty() ? LogParameters.getTimestamp() : timestamp;
        this.file = file;
        this.function = function;
        this.line = line;
        this.tag = tag;
        this.message = message;
        this.thread = thread;
    }

    public LogParameters(@NonNull LogLevel level, @NonNull String tag, @NonNull String message) {
        this(LogModule.PLATFORM, level, LogParameters.getTimestamp(), "", "", 0, tag, message, LogParameters.getThreadNameOrId());
    }

    private static String getTimestamp() {
        SimpleDateFormat simpleformat = new SimpleDateFormat("yy-MM-dd hh:mm:ss.SSS", Locale.US);
        return simpleformat.format(Calendar.getInstance().getTime()).toString();
    }

    private static String getThreadNameOrId() {
        if (!Thread.currentThread().getName().isEmpty()) {
            return Thread.currentThread().getName();
        }
        return Long.toString(Thread.currentThread().getId());
    }

    public static class Builder {
        @NonNull
        private LogModule module = LogModule.PLATFORM;
        @NonNull
        private LogLevel level;
        @NonNull
        private String timestamp = LogParameters.getTimestamp();
        @NonNull
        public String file = "";
        @NonNull
        private String function = "";
        private int line = 0;
        @NonNull
        private String tag = "";
        @NonNull
        private String message = "";
        @NonNull
        private String thread = LogParameters.getThreadNameOrId();
        @Nullable
        private Throwable tr;

        public Builder(@NonNull LogLevel level, @NonNull String tag, @NonNull String message) {
            Preconditions.checkNotNull(level, "Level must not be null");
            Preconditions.checkNotNull(tag, "Tag must not be null");
            Preconditions.checkNotNull(message, "Message must not be null");
            this.level = level;
            this.tag = tag;
            this.message = message;
        }

        @NonNull
        public Builder module(@NonNull LogModule module) {
            Preconditions.checkNotNull(module, "Module must not be null");
            this.module = module;
            return this;
        }

        @NonNull
        public Builder timestamp(@NonNull String timestamp) {
            Preconditions.checkNotNull(timestamp, "Timestamp must not be null");
            this.timestamp = timestamp;
            return this;
        }

        @NonNull
        public Builder file(@NonNull String file) {
            Preconditions.checkNotNull(file, "Filename must not be null");
            this.file = file;
            return this;
        }

        @NonNull
        public Builder function(@NonNull String function) {
            Preconditions.checkNotNull(function, "Method name must not be null");
            this.function = function;
            return this;
        }

        public Builder line(int line) {
            this.line = line;
            return this;
        }

        @NonNull
        public Builder thread(String thread) {
            Preconditions.checkNotNull(thread, "Thread name or id must not be null");
            this.thread = thread;
            return this;
        }

        @Nullable
        public Builder throwable(Throwable tr) {
            this.tr = tr;
            return this;
        }

        @NonNull
        public LogParameters build() {
            return new LogParameters(this);
        }
    }
}

