/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.AudioOptions;
import com.twilio.voice.AudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Utils;

class LocalAudioTrack
extends AudioTrack {
    private static final Logger logger = Logger.getLogger(LocalAudioTrack.class);
    private final String trackId;
    private final MediaFactory mediaFactory;
    private long nativeLocalAudioTrackHandle;

    public static LocalAudioTrack create(@NonNull Context context, boolean enabled) {
        return LocalAudioTrack.create(context, enabled, new AudioOptions.Builder().build(), null);
    }

    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @NonNull AudioOptions audioOptions) {
        return LocalAudioTrack.create(context, enabled, audioOptions, null);
    }

    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @Nullable String name) {
        return LocalAudioTrack.create(context, enabled, new AudioOptions.Builder().build(), name);
    }

    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @NonNull AudioOptions audioOptions, @Nullable String name) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(audioOptions, "audioOptions must not be null.");
        Preconditions.checkState(Utils.permissionGranted(context, "android.permission.RECORD_AUDIO"), "RECORD_AUDIO permission must be granted to create audio track");
        Object temporaryMediaFactoryOwner = new Object();
        MediaFactory mediaFactory = MediaFactory.instance(temporaryMediaFactoryOwner, context.getApplicationContext());
        LocalAudioTrack localAudioTrack = mediaFactory.createAudioTrack(context.getApplicationContext(), enabled, audioOptions, name);
        if (localAudioTrack == null) {
            logger.e("Failed to create local audio track");
        }
        mediaFactory.release(temporaryMediaFactoryOwner);
        return localAudioTrack;
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalAudioTrackHandle);
        }
        logger.w("Local audio track is not enabled because it has been released");
        return false;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getTrackId() {
        return this.trackId;
    }

    public synchronized void enable(boolean enable) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalAudioTrackHandle, enable);
        } else {
            logger.e("Cannot enable a local audio track that has been removed");
        }
    }

    public synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalAudioTrackHandle);
            this.nativeLocalAudioTrackHandle = 0L;
            this.mediaFactory.release(this);
        }
    }

    LocalAudioTrack(long nativeLocalAudioTrackHandle, @NonNull String trackId, @NonNull String name, boolean enabled, Context context) {
        super(enabled, name);
        Preconditions.checkApplicationContext(context, "must create local audio track with application context");
        this.trackId = trackId;
        this.nativeLocalAudioTrackHandle = nativeLocalAudioTrackHandle;
        this.mediaFactory = MediaFactory.instance(this, context);
    }

    boolean isReleased() {
        return this.nativeLocalAudioTrackHandle == 0L;
    }

    synchronized long getNativeHandle() {
        return this.nativeLocalAudioTrackHandle;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    private native void nativeRelease(long var1);
}

