/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.util.Pair;
import com.twilio.voice.Constants;
import com.twilio.voice.Event;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.LogLevel;
import com.twilio.voice.LogParameters;
import com.twilio.voice.MetricEvent;
import com.twilio.voice.RTCStatsSample;
import com.twilio.voice.Voice;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class InsightsUtils {
    InsightsUtils() {
    }

    static RTCStatsSample createRtcSample(Map<String, Pair<String, Class>> data) {
        RTCStatsSample rtcStatsSample = new RTCStatsSample();
        rtcStatsSample.packetsReceived = InsightsUtils.fromString(data.get("packets_received"), Long.class);
        rtcStatsSample.totalPacketsLost = InsightsUtils.fromString(data.get("total_packets_lost"), Long.class);
        rtcStatsSample.fractionLost = InsightsUtils.fromString(data.get("packets_lost_fraction"), Float.class).floatValue();
        rtcStatsSample.packetsLost = InsightsUtils.fromString(data.get("packets_lost"), Long.class);
        rtcStatsSample.totalPacketsSent = InsightsUtils.fromString(data.get("total_packets_sent"), Long.class);
        rtcStatsSample.totalPacketsReceived = InsightsUtils.fromString(data.get("total_packets_received"), Long.class);
        rtcStatsSample.totalBytesReceived = InsightsUtils.fromString(data.get("total_bytes_received"), Long.class);
        rtcStatsSample.totalBytesSent = InsightsUtils.fromString(data.get("total_bytes_sent"), Long.class);
        rtcStatsSample.jitter = InsightsUtils.fromString(data.get("jitter"), Long.class);
        rtcStatsSample.rtt = InsightsUtils.fromString(data.get("rtt"), Long.class);
        rtcStatsSample.audioInputLevel = InsightsUtils.fromString(data.get("audio_level_in"), Long.class);
        rtcStatsSample.audioOutputLevel = InsightsUtils.fromString(data.get("audio_level_out"), Long.class);
        rtcStatsSample.mos = InsightsUtils.fromString(data.get("mos"), Float.class).floatValue();
        rtcStatsSample.codec = InsightsUtils.fromString(data.get("audio_codec"), String.class);
        rtcStatsSample.timestampMS = InsightsUtils.fromString(data.get("timestamp_ms"), String.class);
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df.setTimeZone(tz);
        Date now = new Date(Double.valueOf(rtcStatsSample.timestampMS).longValue());
        rtcStatsSample.timeStamp = df.format(now);
        return rtcStatsSample;
    }

    static JSONArray publishMetrics(RTCStatsSample currentSample, String callSid, Constants.Direction direction, JSONArray payload, EventPublisher publisher) {
        currentSample.setCallSid(callSid);
        currentSample.setDirection(direction);
        if (payload == null) {
            payload = new JSONArray();
        }
        payload.put((Object)currentSample.toJson());
        if (payload.length() == 10) {
            if (publisher != null) {
                try {
                    MetricEvent event = publisher.createMetricEvent("quality-metrics-samples", "metrics-sample", payload);
                    publisher.publishMetrics(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                payload = new JSONArray();
            } else {
                payload = new JSONArray();
            }
        }
        return payload;
    }

    static void processEvent(Map<String, Pair<String, Class>> data, EventPayload.Builder builder, EventPublisher publisher, Constants.Direction direction) {
        if (InsightsUtils.fromString(data.get("group"), String.class).equals("ice-candidate")) {
            if (InsightsUtils.fromString(data.get("name"), String.class).equals("ice-candidate")) {
                InsightsUtils.publishIceCandidateEvent(data, builder, publisher, direction);
            } else if (InsightsUtils.fromString(data.get("name"), String.class).equals("selected-ice-candidate-pair")) {
                InsightsUtils.publishSelectedIceCandidateEvent(data, builder, publisher, direction);
            }
        } else if (InsightsUtils.fromString(data.get("name"), String.class).equals("error") || InsightsUtils.fromString(data.get("name"), String.class).equals("listening-error") || InsightsUtils.fromString(data.get("name"), String.class).equals("unsupported-cancel-message-error")) {
            if (data.get("error_code") != null) {
                InsightsUtils.publishConnectionErrorEvent(data, builder, publisher);
            }
        } else {
            InsightsUtils.publishEvent(data, builder, publisher);
        }
    }

    static void processWarningEvent(Map<String, Pair<String, Class>> data, EventPayload.Builder builder, EventPublisher publisher) {
        String eventName = InsightsUtils.fromString(data.get("name"), String.class);
        Constants.SeverityLevel severityLevel = Constants.SeverityLevel.valueOf(InsightsUtils.fromString(data.get("level"), String.class));
        String group = InsightsUtils.fromString(data.get("group"), String.class);
        EventPayload warningEventPayload = InsightsUtils.createWarningEventPayload(data, builder);
        InsightsUtils.publish(warningEventPayload, severityLevel, group, eventName, publisher);
    }

    private static void publishConnectionErrorEvent(Map<String, Pair<String, Class>> data, EventPayload.Builder builder, EventPublisher publisher) {
        String eventName = InsightsUtils.fromString(data.get("name"), String.class);
        Constants.SeverityLevel severityLevel = Constants.SeverityLevel.valueOf(InsightsUtils.fromString(data.get("level"), String.class));
        String group = InsightsUtils.fromString(data.get("group"), String.class);
        EventPayload eventPayload = builder.errorCode(InsightsUtils.fromString(data.get("error_code"), Long.class)).errorMessage(InsightsUtils.fromString(data.get("error_message"), String.class) + " : " + InsightsUtils.fromString(data.get("error_explanation"), String.class)).build();
        InsightsUtils.publish(eventPayload, severityLevel, group, eventName, publisher);
    }

    private static void publishEvent(Map<String, Pair<String, Class>> data, EventPayload.Builder builder, EventPublisher publisher) {
        String eventName = InsightsUtils.fromString(data.get("name"), String.class);
        Constants.SeverityLevel severityLevel = Constants.SeverityLevel.valueOf(InsightsUtils.fromString(data.get("level"), String.class));
        String group = InsightsUtils.fromString(data.get("group"), String.class);
        EventPayload eventPayload = builder.build();
        InsightsUtils.publish(eventPayload, severityLevel, group, eventName, publisher);
    }

    private static void publishIceCandidateEvent(Map<String, Pair<String, Class>> data, EventPayload.Builder builder, EventPublisher publisher, Constants.Direction direction) {
        String eventName = InsightsUtils.fromString(data.get("name"), String.class);
        Constants.SeverityLevel severityLevel = Constants.SeverityLevel.valueOf(InsightsUtils.fromString(data.get("level"), String.class));
        String group = InsightsUtils.fromString(data.get("group"), String.class);
        EventPayload eventPayload = null;
        eventPayload = builder.transportId(InsightsUtils.fromString(data.get("transport_id"), String.class)).isRemote(InsightsUtils.fromString(data.get("is_remote"), Boolean.class)).ip(InsightsUtils.fromString(data.get("ip"), String.class)).port(InsightsUtils.fromString(data.get("port"), Long.class)).protocol(InsightsUtils.fromString(data.get("protocol"), String.class)).candidateType(InsightsUtils.fromString(data.get("candidate_type"), String.class)).priority(InsightsUtils.fromString(data.get("priority"), Long.class)).url(InsightsUtils.fromString(data.get("url"), String.class)).deleted(InsightsUtils.fromString(data.get("deleted"), Boolean.class)).networkCost(InsightsUtils.fromString(data.get("network-cost"), Long.class)).networkId(InsightsUtils.fromString(data.get("network-id"), Long.class)).relatedPort(InsightsUtils.fromString(data.get("related_port"), Long.class)).level(InsightsUtils.fromString(data.get("level"), String.class)).relatedAddress(InsightsUtils.fromString(data.get("related_address"), String.class)).name(InsightsUtils.fromString(data.get("name"), String.class)).tcpType(InsightsUtils.fromString(data.get("tcp_type"), String.class)).networkType(InsightsUtils.fromString(data.get("network-type"), String.class)).direction(direction).build();
        InsightsUtils.publish(eventPayload, severityLevel, group, eventName, publisher);
    }

    private static void publishSelectedIceCandidateEvent(Map<String, Pair<String, Class>> data, EventPayload.Builder builder, EventPublisher publisher, Constants.Direction direction) {
        String eventName = InsightsUtils.fromString(data.get("name"), String.class);
        Constants.SeverityLevel severityLevel = Constants.SeverityLevel.valueOf(InsightsUtils.fromString(data.get("level"), String.class));
        String group = InsightsUtils.fromString(data.get("group"), String.class);
        EventPayload eventPayload = null;
        eventPayload = builder.reason(InsightsUtils.fromString(data.get("reason"), String.class)).lastDataReceivedMs(InsightsUtils.fromString(data.get("last_data_received_ms"), Long.class)).level(InsightsUtils.fromString(data.get("level"), String.class)).name(InsightsUtils.fromString(data.get("name"), String.class)).localCandidate(InsightsUtils.fromString(data.get("local_candidate"), JSONObject.class)).remoteCandidate(InsightsUtils.fromString(data.get("remote_candidate"), JSONObject.class)).build();
        InsightsUtils.publish(eventPayload, severityLevel, group, eventName, publisher);
    }

    private static void publish(EventPayload eventPayload, Constants.SeverityLevel severityLogLevel, String group, String eventName, EventPublisher publisher) {
        try {
            JSONObject connectionEventPayload = eventPayload.getPayload();
            Voice.getLogger().log(new LogParameters.Builder(LogLevel.INFO, Class.class.toString(), connectionEventPayload.toString()).build());
            if (publisher != null) {
                Event event = publisher.createEvent(severityLogLevel, group, eventName, connectionEventPayload);
                publisher.publish(severityLogLevel, group, eventName, event);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static <T> T fromString(Pair<String, Class> stringValuePair, Class<T> reifiedType) {
        Object object = null;
        if (((Class)stringValuePair.second).equals(Boolean.class)) {
            object = Boolean.parseBoolean((String)stringValuePair.first);
        } else if (((Class)stringValuePair.second).equals(Float.class)) {
            object = Float.valueOf(Float.parseFloat((String)stringValuePair.first));
        } else if (((Class)stringValuePair.second).equals(Long.class)) {
            object = Long.parseLong((String)stringValuePair.first);
        } else if (((Class)stringValuePair.second).equals(JSONObject.class)) {
            try {
                object = new JSONObject((String)stringValuePair.first);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            object = stringValuePair.first;
        }
        return reifiedType.cast(object);
    }

    static EventPayload createWarningEventPayload(Map<String, Pair<String, Class>> data, EventPayload.Builder builder) {
        String group = InsightsUtils.fromString(data.get("group"), String.class);
        String values = InsightsUtils.fromString(data.get("values"), String.class);
        Pair<String, Class> thresholdStringValue = data.get("threshold");
        EventPayload warningEventPayload = group.equals("audio-level-warning-raised") ? builder.value(values).qualityThresholdValuePair(thresholdStringValue).payLoadType("application/json").build() : builder.values(values).qualityThresholdValuePair(thresholdStringValue).payLoadType("application/json").build();
        return warningEventPayload;
    }

    static void publishLoggerEvent(EventPublisher publisher, EventPayload eventPayload) {
        InsightsUtils.publish(eventPayload, Constants.SeverityLevel.INFO, "settings", "logger", publisher);
    }

    static void publishCallMessageSentEvent(EventPublisher publisher, EventPayload eventPayload) {
        InsightsUtils.publish(eventPayload, Constants.SeverityLevel.INFO, "call-message", "user-defined-message", publisher);
    }

    static void publishCallMessageReceivedEvent(EventPublisher publisher, EventPayload eventPayload) {
        InsightsUtils.publish(eventPayload, Constants.SeverityLevel.INFO, "call-message", "user-defined-message", publisher);
    }

    static void publishCallMessageSendFailedEvent(EventPublisher publisher, EventPayload eventPayload) {
        InsightsUtils.publish(eventPayload, Constants.SeverityLevel.ERROR, "call-message", "error", publisher);
    }
}

