/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.Constants;
import com.twilio.voice.Event;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.RegistrarListener;
import com.twilio.voice.RegistrationException;
import com.twilio.voice.SidUtil;
import com.twilio.voice.Utils;
import com.twilio.voice.VoiceURLConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

class HttpsRegistrar {
    private static final String REGISTRATION_ID_LOCATION = "Location";
    @VisibleForTesting
    static final String JSON_MESSAGE_KEY = "message";
    @VisibleForTesting
    static final String JSON_CODE_KEY = "code";
    @VisibleForTesting
    static final String DEFAULT_REGISTRATION_FAILED_MESSAGE = "Registration failed";
    @VisibleForTesting
    static final String DEFAULT_UNREGISTRATION_FAILED_MESSAGE = "Unregistration failed";

    private HttpsRegistrar() {
    }

    public static void register(String accessToken, String jsonPayloadString, String hostURL, RegistrarListener registrarListener) {
        HttpsRegistrar.register(accessToken, jsonPayloadString, hostURL, false, registrarListener);
    }

    public static void register(String accessToken, String jsonPayloadString, String hostURL, boolean isUnregistrationRequest, RegistrarListener registrarListener) {
        String requestId = SidUtil.generateGUID("RQ", accessToken);
        ExecutorService executor = Executors.newCachedThreadPool();
        Handler handler = Utils.createHandler();
        executor.execute(() -> {
            HttpsURLConnection urlConnection;
            block8: {
                urlConnection = null;
                try {
                    urlConnection = VoiceURLConnection.create(accessToken, hostURL, "POST");
                    urlConnection.addRequestProperty("X-Twilio-Request-Id", requestId);
                    OutputStreamWriter wr = new OutputStreamWriter(urlConnection.getOutputStream());
                    wr.write(jsonPayloadString);
                    wr.close();
                    int result = urlConnection.getResponseCode();
                    String responseMessage = urlConnection.getResponseMessage();
                    if (result == 201) {
                        String registrationLocation = urlConnection.getHeaderField(REGISTRATION_ID_LOCATION);
                        if (registrationLocation != null) {
                            if (!isUnregistrationRequest) {
                                HttpsRegistrar.publishRegistrationSuccessfulEvent(accessToken, requestId, "registration");
                            }
                            handler.post(() -> registrarListener.onSuccess(registrationLocation));
                        } else {
                            String errorMessage = isUnregistrationRequest ? DEFAULT_UNREGISTRATION_FAILED_MESSAGE : DEFAULT_REGISTRATION_FAILED_MESSAGE;
                            HttpsRegistrar.publishError(isUnregistrationRequest, accessToken, requestId, result, responseMessage);
                            handler.post(() -> registrarListener.onError(new RegistrationException(31301, errorMessage, "Registration Location is null")));
                        }
                        break block8;
                    }
                    JSONObject jsonObject = HttpsRegistrar.processJSONError(urlConnection.getErrorStream());
                    int jsonCode = jsonObject.getInt(JSON_CODE_KEY);
                    String jsonMessage = jsonObject.getString(JSON_MESSAGE_KEY);
                    RegistrationException registrationException = HttpsRegistrar.handleHttpErrorCode(isUnregistrationRequest, result, jsonCode, jsonMessage, responseMessage);
                    HttpsRegistrar.publishError(isUnregistrationRequest, accessToken, requestId, registrationException.getErrorCode(), registrationException.getMessage() + " : " + registrationException.getExplanation());
                    handler.post(() -> registrarListener.onError(registrationException));
                }
                catch (Exception e) {
                    try {
                        HttpsRegistrar.handleException(isUnregistrationRequest, e, urlConnection, handler, registrarListener);
                        String errorMessage = isUnregistrationRequest ? DEFAULT_UNREGISTRATION_FAILED_MESSAGE : DEFAULT_REGISTRATION_FAILED_MESSAGE;
                        HttpsRegistrar.publishError(isUnregistrationRequest, accessToken, requestId, 31301, errorMessage + " : " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        VoiceURLConnection.release(urlConnection);
                        throw throwable;
                    }
                    VoiceURLConnection.release(urlConnection);
                }
            }
            VoiceURLConnection.release(urlConnection);
        });
    }

    public static void unregister(String accessToken, String hostURL, RegistrarListener registrarListener) {
        boolean isUnregistrationRequest = true;
        String requestId = SidUtil.generateGUID("RQ", accessToken);
        ExecutorService executor = Executors.newCachedThreadPool();
        Handler handler = Utils.createHandler();
        executor.execute(() -> {
            HttpsURLConnection urlConnection;
            block5: {
                urlConnection = null;
                try {
                    urlConnection = VoiceURLConnection.create(accessToken, hostURL, "DELETE");
                    urlConnection.addRequestProperty("X-Twilio-Request-Id", requestId);
                    urlConnection.connect();
                    int result = urlConnection.getResponseCode();
                    String responseMessage = urlConnection.getResponseMessage();
                    if (result == 200 || result == 204) {
                        HttpsRegistrar.publishRegistrationSuccessfulEvent(accessToken, requestId, "unregistration");
                        handler.post(() -> registrarListener.onSuccess(null));
                        break block5;
                    }
                    JSONObject jsonObject = HttpsRegistrar.processJSONError(urlConnection.getErrorStream());
                    int jsonCode = jsonObject.getInt(JSON_CODE_KEY);
                    String jsonMessage = jsonObject.getString(JSON_MESSAGE_KEY);
                    RegistrationException registrationException = HttpsRegistrar.handleHttpErrorCode(true, result, jsonCode, jsonMessage, responseMessage);
                    HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "unregistration-error", registrationException.getErrorCode(), registrationException.getMessage() + " : " + registrationException.getExplanation());
                    handler.post(() -> registrarListener.onError(registrationException));
                }
                catch (Exception e) {
                    try {
                        HttpsRegistrar.handleException(true, e, urlConnection, handler, registrarListener);
                        String errorMessage = DEFAULT_UNREGISTRATION_FAILED_MESSAGE;
                        HttpsRegistrar.publishError(true, accessToken, requestId, 31301, errorMessage + " : " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        VoiceURLConnection.release(urlConnection);
                        throw throwable;
                    }
                    VoiceURLConnection.release(urlConnection);
                }
            }
            VoiceURLConnection.release(urlConnection);
        });
    }

    private static void handleException(Boolean isUnregistrationRequest, Exception e, HttpsURLConnection urlConnection, Handler handler, RegistrarListener registrarListener) {
        String errorMessage;
        String string = errorMessage = isUnregistrationRequest != false ? DEFAULT_UNREGISTRATION_FAILED_MESSAGE : DEFAULT_REGISTRATION_FAILED_MESSAGE;
        if (urlConnection != null) {
            try {
                JSONObject jsonObject = HttpsRegistrar.processJSONError(urlConnection.getErrorStream());
                int code = jsonObject.getInt(JSON_CODE_KEY);
                String message = jsonObject.getString(JSON_MESSAGE_KEY);
                handler.post(() -> registrarListener.onError(HttpsRegistrar.handleHttpAuthErrorCode(isUnregistrationRequest, code, message)));
            }
            catch (Exception e1) {
                handler.post(() -> registrarListener.onError(new RegistrationException(31301, errorMessage, e.getMessage())));
            }
        } else {
            handler.post(() -> registrarListener.onError(new RegistrationException(31301, errorMessage, e.getMessage())));
        }
    }

    @VisibleForTesting
    static RegistrationException handleHttpErrorCode(boolean isUnregistrationRequest, int httpCode, int jsonCode, String jsonMessage, String httpResponse) {
        RegistrationException registrationException;
        int errorCode = 31301;
        String errorMessage = isUnregistrationRequest ? DEFAULT_UNREGISTRATION_FAILED_MESSAGE : DEFAULT_REGISTRATION_FAILED_MESSAGE;
        String errorExplanation = String.valueOf(jsonCode) + " : " + jsonMessage;
        switch (httpCode) {
            case 401: {
                registrationException = HttpsRegistrar.handleHttpAuthErrorCode(isUnregistrationRequest, jsonCode, jsonMessage);
                break;
            }
            case 400: {
                errorCode = RegistrationException.BadRequestException.getErrorCode();
                errorMessage = RegistrationException.BadRequestException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.BadRequestException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 403: {
                errorCode = RegistrationException.ForbiddenException.getErrorCode();
                errorMessage = RegistrationException.ForbiddenException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.ForbiddenException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 404: {
                errorCode = RegistrationException.NotFoundException.getErrorCode();
                errorMessage = RegistrationException.NotFoundException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.NotFoundException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 408: {
                errorCode = RegistrationException.RequestTimeoutException.getErrorCode();
                errorMessage = RegistrationException.RequestTimeoutException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.RequestTimeoutException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 409: {
                errorCode = RegistrationException.ConflictException.getErrorCode();
                errorMessage = RegistrationException.ConflictException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.ConflictException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 429: {
                errorCode = RegistrationException.TooManyRequestException.getErrorCode();
                errorMessage = RegistrationException.TooManyRequestException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.TooManyRequestException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 500: {
                errorCode = RegistrationException.InternalServerErrorException.getErrorCode();
                errorMessage = RegistrationException.InternalServerErrorException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.InternalServerErrorException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 502: {
                errorCode = RegistrationException.BadGatewayException.getErrorCode();
                errorMessage = RegistrationException.BadGatewayException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.BadGatewayException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 503: {
                errorCode = RegistrationException.ServiceUnavailableException.getErrorCode();
                errorMessage = RegistrationException.ServiceUnavailableException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.ServiceUnavailableException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 504: {
                errorCode = RegistrationException.GatewayTimeoutException.getErrorCode();
                errorMessage = RegistrationException.GatewayTimeoutException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.GatewayTimeoutException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            case 426: {
                errorCode = RegistrationException.UpgradeRequiredException.getErrorCode();
                errorMessage = RegistrationException.UpgradeRequiredException.getMessage();
                errorExplanation = jsonMessage != null ? jsonCode + " : " + jsonMessage : RegistrationException.UpgradeRequiredException.getExplanation();
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            default: {
                errorExplanation = jsonCode == 0 ? String.valueOf(httpCode) + " : " + httpResponse : errorExplanation;
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
            }
        }
        return registrationException;
    }

    private static RegistrationException handleHttpAuthErrorCode(boolean isUnregistrationRequest, int jsonErrorCode, String jsonErrorMessage) {
        RegistrationException registrationException;
        int errorCode = jsonErrorCode;
        String errorMessage = jsonErrorMessage;
        String errorExplanation = jsonErrorCode + " : " + errorMessage;
        switch (jsonErrorCode) {
            case 20101: 
            case 20102: 
            case 20103: 
            case 20104: 
            case 20105: 
            case 20106: 
            case 20107: 
            case 20151: 
            case 20157: 
            case 20403: 
            case 51007: {
                registrationException = new RegistrationException(errorCode, errorMessage, errorExplanation);
                break;
            }
            default: {
                registrationException = !isUnregistrationRequest ? new RegistrationException(31301, DEFAULT_REGISTRATION_FAILED_MESSAGE, errorExplanation) : new RegistrationException(31301, DEFAULT_UNREGISTRATION_FAILED_MESSAGE, errorExplanation);
            }
        }
        return registrationException;
    }

    private static JSONObject processJSONError(InputStream errorStream) throws IOException, JSONException {
        StringBuilder stringBuilder = new StringBuilder();
        if (errorStream != null) {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(errorStream));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append('\n');
            }
            bufferedReader.close();
        }
        return new JSONObject(stringBuilder.toString());
    }

    private static void publishError(boolean isUnregistrationRequest, String accessToken, String requestId, int errorCode, String errorMessage) {
        if (!isUnregistrationRequest) {
            HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "registration-error", errorCode, errorMessage);
        } else {
            HttpsRegistrar.publishRegistrationErrorEvent(accessToken, requestId, "unregistration-registration-error", errorCode, errorMessage);
        }
    }

    private static void publishRegistrationErrorEvent(String accessToken, String requestId, String eventName, int errorCode, String errorMessage) {
        EventPublisher publisher = new EventPublisher(Constants.getClientSdkProductName(), accessToken);
        EventPayload eventPayload = new EventPayload.Builder().productName(Constants.getClientSdkProductName()).requestId(requestId).errorCode(Long.valueOf(errorCode)).errorMessage(errorMessage).payLoadType("application/json").build();
        try {
            JSONObject registrationEventPayload = eventPayload.getPayload();
            Event event = publisher.createEvent(Constants.SeverityLevel.ERROR, "registration", eventName, registrationEventPayload);
            publisher.publish(Constants.SeverityLevel.ERROR, "registration", eventName, event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void publishRegistrationSuccessfulEvent(String accessToken, String requestId, String eventName) {
        EventPublisher publisher = new EventPublisher(Constants.getClientSdkProductName(), accessToken);
        EventPayload eventPayload = new EventPayload.Builder().productName(Constants.getClientSdkProductName()).requestId(requestId).payLoadType("application/json").build();
        try {
            JSONObject registrationEventPayload = eventPayload.getPayload();
            Event event = publisher.createEvent(Constants.SeverityLevel.INFO, "registration", eventName, registrationEventPayload);
            publisher.publish(Constants.SeverityLevel.INFO, "registration", eventName, event);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

