/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.AccessTokenParseException;
import com.twilio.voice.AccessTokenParser;
import com.twilio.voice.Constants;
import com.twilio.voice.Event;
import com.twilio.voice.Logger;
import com.twilio.voice.MetricEvent;
import com.twilio.voice.Utils;
import com.twilio.voice.VoiceException;
import com.twilio.voice.VoiceURLConnection;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

class EventPublisher {
    private static final Logger logger = Logger.getLogger(EventPublisher.class);
    private static final String TAG = EventPublisher.class.getSimpleName();
    private Map<EventPublisherListener, Handler> listenerMap = new HashMap<EventPublisherListener, Handler>();
    private Context context;
    private String accessToken;
    private String publisherName;
    private String homeRegion;
    String twilioProdSdkMetricsGatewayURL;
    String twilioProdSdkEventGatewayURL;
    int result = 0;
    private EventPublisherStatus eventPublisherStatus = new EventPublisherStatus();
    List<Integer> errorCodeList = Arrays.asList(403);
    @VisibleForTesting
    private EventPublisherEventListener publisherPublishEventListener;

    EventPublisher(String publisherName, String accessToken) {
        this(null, publisherName, accessToken);
    }

    EventPublisher(@Nullable Context context, String publisherName, String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken must not be null.");
        }
        if (publisherName == null) {
            throw new NullPointerException("publisherName must not be null.");
        }
        this.context = context;
        this.accessToken = accessToken;
        this.publisherName = publisherName;
        this.twilioProdSdkMetricsGatewayURL = Constants.getKeyKibanaMetricsHostUrl();
        this.twilioProdSdkEventGatewayURL = Constants.getKeyKibanaEventGatewayHostUrl();
        try {
            this.homeRegion = new AccessTokenParser(accessToken).getHomeRegion();
        }
        catch (AccessTokenParseException e) {
            e.printStackTrace();
        }
        if (this.homeRegion != null) {
            this.updateServiceHostUrlsWithHomeRegion(this.homeRegion);
        }
    }

    private void updateServiceHostUrlsWithHomeRegion(String homeRegion) {
        this.twilioProdSdkMetricsGatewayURL = String.format("https://eventgw.%s.twilio.com/v4/EndpointMetrics", homeRegion);
        this.twilioProdSdkEventGatewayURL = String.format("https://eventgw.%s.twilio.com/v4/EndpointEvents", homeRegion);
    }

    void addListener(EventPublisherListener listener) {
        Handler handler = Utils.createHandler();
        this.listenerMap.put(listener, handler);
    }

    @VisibleForTesting
    void addEventPublisherEventListener(EventPublisherEventListener listener) {
        this.publisherPublishEventListener = listener;
    }

    void removeListener(EventPublisherListener listener) {
        this.listenerMap.remove(listener);
    }

    void publishMetrics(MetricEvent event) throws Exception {
        if (event != null) {
            JSONObject eventData = event.toJSONObject(this.context);
            this.publish(eventData.toString(), this.twilioProdSdkMetricsGatewayURL);
            if (this.publisherPublishEventListener != null) {
                this.publisherPublishEventListener.onMetricEventPublished(event);
            }
        }
    }

    MetricEvent createMetricEvent(String group, String name, JSONArray payload) {
        return new MetricEvent.Builder().productName(this.publisherName).eventName(name).groupName(group).level(Constants.SeverityLevel.INFO).payLoadType("application/json").payLoad(payload).build();
    }

    void publish(Constants.SeverityLevel level, String group, String name, Event event) throws Exception {
        if (this.publisherPublishEventListener != null && !this.eventPublisherStatus.isPublishingInvalidated()) {
            this.publisherPublishEventListener.onEventPublished(level, group, name);
        }
        JSONObject eventData = event.toJSONObject(this.context);
        this.publish(eventData.toString(), this.twilioProdSdkEventGatewayURL);
    }

    Event createEvent(Constants.SeverityLevel level, String group, String name, JSONObject payload) {
        return new Event.Builder().productName(this.publisherName).eventName(name).groupName(group).level(level).payLoadType("application/json").payLoad(payload).build();
    }

    private void publish(String eventData, String hostURL) {
        ExecutorService executor = Executors.newCachedThreadPool();
        executor.submit(() -> {
            block8: {
                block9: {
                    HttpsURLConnection urlConnection;
                    block7: {
                        if (this.eventPublisherStatus.isPublishingInvalidated()) break block9;
                        logger.d("Start publishing events to : " + hostURL + "\n" + eventData);
                        urlConnection = null;
                        try {
                            int numRead;
                            urlConnection = VoiceURLConnection.create(this.accessToken, hostURL, "POST");
                            urlConnection.setRequestProperty("Content-Encoding", "gzip");
                            urlConnection.setRequestProperty("Accept-Encoding", "gzip");
                            GZIPOutputStream outputStream = new GZIPOutputStream(urlConnection.getOutputStream());
                            outputStream.write(eventData.getBytes());
                            outputStream.close();
                            this.result = urlConnection.getResponseCode();
                            String responseMessage = urlConnection.getResponseMessage();
                            if (this.result == 200) {
                                logger.d("Response: " + this.result + " - " + responseMessage);
                                break block7;
                            }
                            if (this.errorCodeList.contains(this.result)) {
                                logger.e(String.format(Locale.getDefault(), "Invalidating further publishing : %d - %s", this.result, responseMessage));
                                this.eventPublisherStatus.invalidatePublishing(true);
                            }
                            char[] buffer = new char[1024];
                            StringBuilder stringBuilder = new StringBuilder();
                            InputStreamReader inputStream = new InputStreamReader((InputStream)new GZIPInputStream(urlConnection.getErrorStream()), StandardCharsets.UTF_8);
                            while ((numRead = inputStream.read(buffer)) > 0) {
                                stringBuilder.append(buffer, 0, numRead);
                            }
                            String jsonString = stringBuilder.toString();
                            String explanation = String.format(Locale.getDefault(), "%d-%s-%s", this.result, responseMessage, jsonString);
                            logger.d("Response: " + explanation);
                            this.eventPublisherStatus.setErrorDetails(this.result, responseMessage, explanation);
                            this.notifyListeners(this.result, responseMessage, explanation);
                        }
                        catch (Exception e) {
                            try {
                                logger.e(e.toString());
                            }
                            catch (Throwable throwable) {
                                VoiceURLConnection.release(urlConnection);
                                throw throwable;
                            }
                            VoiceURLConnection.release(urlConnection);
                            break block8;
                        }
                    }
                    VoiceURLConnection.release(urlConnection);
                    break block8;
                }
                this.notifyListeners(this.result, this.eventPublisherStatus.getResponseMessage(), this.eventPublisherStatus.getExplanation());
            }
            return null;
        });
        executor.shutdown();
    }

    private void notifyListeners(final int errorCode, final String errorMessage, final String explanation) {
        for (Map.Entry<EventPublisherListener, Handler> entry : this.listenerMap.entrySet()) {
            final EventPublisherListener listener = entry.getKey();
            Handler handler = entry.getValue();
            if (handler == null) continue;
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(new VoiceException(errorCode, errorMessage, explanation){});
                    }
                }
            });
        }
    }

    class EventPublisherStatus {
        private volatile boolean invalidatePublishing = false;
        private int errorCode = 0;
        private String responseMessage = "";
        private String explanation;

        EventPublisherStatus() {
        }

        public boolean isPublishingInvalidated() {
            return this.invalidatePublishing;
        }

        public void invalidatePublishing(boolean invalidatePublishing) {
            this.invalidatePublishing = invalidatePublishing;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public void setErrorDetails(int errorCode, String responseMessage, String explanation) {
            this.errorCode = errorCode;
            this.responseMessage = responseMessage;
            this.explanation = explanation;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }

    @VisibleForTesting
    static interface EventPublisherEventListener {
        public void onEventPublished(Constants.SeverityLevel var1, String var2, String var3);

        public void onMetricEventPublished(MetricEvent var1);
    }

    static interface EventPublisherListener {
        public void onError(VoiceException var1);
    }
}

