/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.Call;
import com.twilio.voice.CallMessage;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InsightsUtils;
import com.twilio.voice.Utils;
import com.twilio.voice.VoiceException;

public class CallMessageListenerProxy
implements Call.CallMessageListener {
    private final Call.CallMessageListener callMessageListener;
    private final EventPublisher publisher;
    private Handler handler = Utils.createHandler();

    public CallMessageListenerProxy(@NonNull EventPublisher publisher, @Nullable Call.CallMessageListener callMessageListener) {
        this.publisher = publisher;
        this.callMessageListener = callMessageListener;
    }

    @Override
    public void onMessageReceived(String callSid, CallMessage callMessage) {
        InsightsUtils.publishCallMessageReceivedEvent(this.publisher, new EventPayload.Builder().productName(Constants.getClientSdkProductName()).callSid(callSid).payLoadType("application/json").callMessageEventType(Constants.CallMessageEventType.RECEIVED).voiceEventSid(callMessage.getVoiceEventSID()).build());
        if (null != this.callMessageListener) {
            this.handler.post(() -> this.callMessageListener.onMessageReceived(callSid, callMessage));
        }
    }

    @Override
    public void onMessageSent(String callSid, String voiceEventSID) {
        InsightsUtils.publishCallMessageSentEvent(this.publisher, new EventPayload.Builder().productName(Constants.getClientSdkProductName()).callSid(callSid).payLoadType("application/json").callMessageEventType(Constants.CallMessageEventType.SENT).voiceEventSid(voiceEventSID).build());
        if (null != this.callMessageListener) {
            this.handler.post(() -> this.callMessageListener.onMessageSent(callSid, voiceEventSID));
        }
    }

    @Override
    public void onMessageFailure(String callSid, String voiceEventSID, VoiceException error) {
        InsightsUtils.publishCallMessageSendFailedEvent(this.publisher, new EventPayload.Builder().productName(Constants.getClientSdkProductName()).callSid(callSid).payLoadType("application/json").voiceEventSid(voiceEventSID).errorCode(Long.valueOf(error.getErrorCode())).errorMessage(error.getLocalizedMessage()).build());
        if (null != this.callMessageListener) {
            this.handler.post(() -> this.callMessageListener.onMessageFailure(callSid, voiceEventSID, error));
        }
    }
}

