/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

public class AudioOptions {
    private final boolean echoCancellation;
    private final boolean autoGainControl;
    private final boolean noiseSuppression;
    private final boolean highpassFilter;
    private final int audioJitterBufferMaxPackets;
    private final int audioJitterBufferMinDelayMs;

    private AudioOptions(Builder builder) {
        this.echoCancellation = builder.echoCancellation;
        this.autoGainControl = builder.autoGainControl;
        this.noiseSuppression = builder.noiseSuppression;
        this.highpassFilter = builder.highpassFilter;
        this.audioJitterBufferMaxPackets = builder.audioJitterBufferMaxPackets;
        this.audioJitterBufferMinDelayMs = builder.audioJitterBufferMinDelayMs;
    }

    public String toString() {
        return "AudioOptions{echoCancellation=" + this.echoCancellation + ", autoGainControl=" + this.autoGainControl + ", noiseSuppression=" + this.noiseSuppression + ", highpassFilter=" + this.highpassFilter + ", audioJitterBufferMaxPackets=" + this.audioJitterBufferMaxPackets + ", audioJitterBufferMinDelayMs=" + this.audioJitterBufferMinDelayMs + '}';
    }

    public boolean isEchoCancellationEnabled() {
        return this.echoCancellation;
    }

    public boolean isAutoGainControlEnabled() {
        return this.autoGainControl;
    }

    public boolean isNoiseSuppressionEnabled() {
        return this.noiseSuppression;
    }

    public boolean isHighpassFilterEnabled() {
        return this.highpassFilter;
    }

    public int getAudioJitterBufferMaxPackets() {
        return this.audioJitterBufferMaxPackets;
    }

    public int getAudioJitterBufferMinDelayMs() {
        return this.audioJitterBufferMinDelayMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AudioOptions)) {
            return false;
        }
        AudioOptions audioOptions = (AudioOptions)o;
        return this.echoCancellation == audioOptions.echoCancellation && this.autoGainControl == audioOptions.autoGainControl && this.noiseSuppression == audioOptions.noiseSuppression && this.highpassFilter == audioOptions.highpassFilter && this.audioJitterBufferMaxPackets == audioOptions.audioJitterBufferMaxPackets && this.audioJitterBufferMinDelayMs == audioOptions.audioJitterBufferMinDelayMs;
    }

    public static final class Builder {
        private boolean echoCancellation = true;
        private boolean autoGainControl = true;
        private boolean noiseSuppression = true;
        private boolean highpassFilter = true;
        private int audioJitterBufferMaxPackets = 200;
        private int audioJitterBufferMinDelayMs = 0;

        public Builder echoCancellation(boolean echoCancellation) {
            this.echoCancellation = echoCancellation;
            return this;
        }

        public Builder autoGainControl(boolean autoGainControl) {
            this.autoGainControl = autoGainControl;
            return this;
        }

        public Builder noiseSuppression(boolean noiseSuppression) {
            this.noiseSuppression = noiseSuppression;
            return this;
        }

        public Builder highpassFilter(boolean highpassFilter) {
            this.highpassFilter = highpassFilter;
            return this;
        }

        public Builder audioJitterBufferMaxPackets(int maxPackets) {
            this.audioJitterBufferMaxPackets = maxPackets = maxPackets < 20 ? 20 : maxPackets;
            return this;
        }

        public Builder audioJitterBufferMinDelayMs(int minDelayMs) {
            this.audioJitterBufferMinDelayMs = minDelayMs = minDelayMs < 0 ? 0 : minDelayMs;
            return this;
        }

        public AudioOptions build() {
            return new AudioOptions(this);
        }
    }
}

