package com.twilio.voice;

import java.util.ArrayList;
import java.util.List;

/** Stats report contains stats for all the media tracks that exist in peer connection. */
public class StatsReport {
    private final String peerConnectionId;
    private List<LocalAudioTrackStats> localAudioTrackStats = new ArrayList<>();
    private List<RemoteAudioTrackStats> remoteAudioTrackStats = new ArrayList<>();
    private List<IceCandidatePairStats> iceCandidatePairStats = new ArrayList<>();
    private List<IceCandidateStats> iceCandidateStats = new ArrayList<>();

    StatsReport(String peerConnectionId) {
        this.peerConnectionId = peerConnectionId;
    }

    /** Returns the id of peer connection related to this report. */
    public String getPeerConnectionId() {
        return peerConnectionId;
    }

    /**
     * Returns stats for all local audio tracks in the peer connection.
     *
     * @return a list of local audio tracks stats
     */
    public List<LocalAudioTrackStats> getLocalAudioTrackStats() {
        return localAudioTrackStats;
    }

    /**
     * Returns stats for all remote audio tracks in the peer connection.
     *
     * @return a list of remote audio tracks stats
     */
    public List<RemoteAudioTrackStats> getRemoteAudioTrackStats() {
        return remoteAudioTrackStats;
    }

    /**
     * Returns stats for all ice candidate pairs in the peer connection.
     *
     * @return a list of ice candidate pair stats
     */
    public List<IceCandidatePairStats> getIceCandidatePairStats() {
        return iceCandidatePairStats;
    }

    /**
     * Returns stats for individual ice candidates in the peer connection
     *
     * @return a list of all ice candidate stats
     */
    public List<IceCandidateStats> getIceCandidateStats() {
        return iceCandidateStats;
    }

    void addIceCandidatePairStats(IceCandidatePairStats iceCandidatePairStats) {
        this.iceCandidatePairStats.add(iceCandidatePairStats);
    }

    void addIceCandidateStats(IceCandidateStats iceCandidateStats) {
        this.iceCandidateStats.add(iceCandidateStats);
    }

    void addLocalAudioTrackStats(LocalAudioTrackStats localAudioTrackStats) {
        this.localAudioTrackStats.add(localAudioTrackStats);
    }

    void addAudioTrackStats(RemoteAudioTrackStats remoteAudioTrackStats) {
        this.remoteAudioTrackStats.add(remoteAudioTrackStats);
    }
}
