/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import com.twilio.voice.Constants;
import com.twilio.voice.Logger;
import org.json.JSONObject;

class RTCStatsSample {
    private static final Logger logger = Logger.getLogger(RTCStatsSample.class);
    String timeStamp;
    String timestampMS;
    float mos;
    float fractionLost;
    Long packetsReceived;
    Long packetsLost;
    Long packetsSent;
    Long totalPacketsReceived;
    Long totalPacketsSent;
    Long totalPacketsLost;
    Long totalBytesReceived;
    Long totalBytesSent;
    Long jitter;
    Long rtt;
    Long audioInputLevel;
    Long audioOutputLevel;
    String callSid;
    String codec;
    Constants.Direction direction;

    public Long getPacketsReceived() {
        return this.packetsReceived;
    }

    public Long getPacketsLost() {
        return this.packetsLost;
    }

    public Long getPacketsSent() {
        return this.packetsSent;
    }

    public Long getTotalPacketsReceived() {
        return this.totalPacketsReceived;
    }

    public Long getTotalPacketsSent() {
        return this.totalPacketsSent;
    }

    public Long getTotalPacketsLost() {
        return this.totalPacketsLost;
    }

    public Long getTotalBytesReceived() {
        return this.totalBytesReceived;
    }

    public Long getTotalBytesSent() {
        return this.totalBytesSent;
    }

    public Long getJitter() {
        return this.jitter;
    }

    public Long getRtt() {
        return this.rtt;
    }

    public Long getAudioInputLevel() {
        return this.audioInputLevel == -1L ? -1L : this.audioInputLevel * 128L;
    }

    public Long getAudioOutputLevel() {
        return this.audioOutputLevel == -1L ? -1L : this.audioOutputLevel * 128L;
    }

    public String getCodec() {
        return this.codec;
    }

    public double getFractionLost() {
        return this.fractionLost;
    }

    public String getCallSid() {
        return this.callSid;
    }

    public float getMos() {
        return this.mos;
    }

    public void setCallSid(String callSid) {
        this.callSid = callSid;
    }

    public void setDirection(Constants.Direction direction) {
        this.direction = direction;
    }

    public String getTimestamp() {
        return this.timeStamp;
    }

    public JSONObject toJson() {
        try {
            JSONObject eventJSON = new JSONObject();
            eventJSON.put("timestamp", (Object)this.getTimestamp());
            eventJSON.put("timestamp_ms", (Object)this.getTimestampMillis());
            eventJSON.put("call_sid", (Object)this.getCallSid());
            eventJSON.put("sdk_version", (Object)"6.1.0");
            eventJSON.put("packets_received", (Object)this.getPacketsReceived());
            eventJSON.put("total_packets_lost", (Object)this.getTotalPacketsLost());
            eventJSON.put("packets_lost_fraction", this.getFractionLost());
            eventJSON.put("packets_lost", (Object)this.getPacketsLost());
            eventJSON.put("total_packets_sent", (Object)this.getTotalPacketsSent());
            eventJSON.put("total_packets_received", (Object)this.getTotalPacketsReceived());
            eventJSON.put("total_bytes_received", (Object)this.getTotalBytesReceived());
            eventJSON.put("total_bytes_sent", (Object)this.getTotalBytesSent());
            eventJSON.put("jitter", (Object)this.getJitter());
            eventJSON.put("rtt", (Object)this.getRtt());
            eventJSON.put("audio_level_in", (Object)this.getAudioInputLevel());
            eventJSON.put("audio_level_out", (Object)this.getAudioOutputLevel());
            eventJSON.put("mos", (double)this.getMos());
            eventJSON.put("audio_codec", (Object)this.getCodec());
            eventJSON.put("direction", (Object)this.direction);
            logger.v(eventJSON.toString());
            return eventJSON;
        }
        catch (Exception e) {
            logger.e(e.toString());
            return null;
        }
    }

    public String toString() {
        return "StatsExtended [timestamp=" + this.timeStamp + ", packetsReceived=" + this.packetsReceived + ", packetsLost=" + this.packetsLost + ", packetsSent=" + this.packetsSent + ", bytesReceived=" + this.totalBytesReceived + ", bytesSent=" + this.totalBytesSent + ", jitter=" + this.jitter + ", rtt=" + this.rtt + ", audioInputLevel=" + this.audioInputLevel + ", audioOutputLevel=" + this.audioOutputLevel + "]";
    }

    public String getTimestampMillis() {
        return this.timestampMS;
    }

    public double getMosScore() {
        return this.mos;
    }
}

