/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public final class Logger {
    public static final int INHERIT = 8;
    private static final Map<Class<?>, Logger> loggers = new HashMap();
    private static int globalLevel = 6;
    private final String name;
    private int level = 8;

    private Logger(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(Class<?> cls) {
        if (!loggers.containsKey(cls)) {
            Map<Class<?>, Logger> map = loggers;
            synchronized (map) {
                if (!loggers.containsKey(cls)) {
                    loggers.put(cls, new Logger(cls.getSimpleName()));
                }
            }
        }
        return loggers.get(cls);
    }

    public static int getLogLevel() {
        return globalLevel;
    }

    public static void setLogLevel(int level) {
        globalLevel = level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isVerboseEnabled() {
        return this.level <= 2 || this.level == 8 && globalLevel <= 2;
    }

    public boolean isDebugEnabled() {
        return this.level <= 3 || this.level == 8 && globalLevel <= 3;
    }

    public boolean isInfoEnabled() {
        return this.level <= 4 || this.level == 8 && globalLevel <= 4;
    }

    public boolean isWarnEnabled() {
        return this.level <= 5 || this.level == 8 && globalLevel <= 5;
    }

    public boolean isErrorEnabled() {
        return this.level <= 6 || this.level == 8 && globalLevel <= 6;
    }

    public void v(String msg, Throwable t) {
        if (this.isVerboseEnabled()) {
            Log.v((String)this.name, (String)msg, (Throwable)t);
        }
    }

    public void v(String msg) {
        if (this.isVerboseEnabled()) {
            Log.v((String)this.name, (String)msg);
        }
    }

    public void d(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            Log.d((String)this.name, (String)msg, (Throwable)t);
        }
    }

    public void d(String msg) {
        if (this.isDebugEnabled()) {
            Log.d((String)this.name, (String)msg);
        }
    }

    public void i(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            Log.i((String)this.name, (String)msg, (Throwable)t);
        }
    }

    public void i(String msg) {
        if (this.isInfoEnabled()) {
            Log.i((String)this.name, (String)msg);
        }
    }

    public void w(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            Log.w((String)this.name, (String)msg, (Throwable)t);
        }
    }

    public void w(String msg) {
        if (this.isWarnEnabled()) {
            Log.w((String)this.name, (String)msg);
        }
    }

    public void e(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            Log.e((String)this.name, (String)msg, (Throwable)t);
        }
    }

    public void e(String msg) {
        if (this.isErrorEnabled()) {
            Log.e((String)this.name, (String)msg);
        }
    }
}

