/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.AccessTokenParseException;
import com.twilio.voice.AccessTokenParser;
import com.twilio.voice.Constants;
import com.twilio.voice.Event;
import com.twilio.voice.Logger;
import com.twilio.voice.MetricEvent;
import com.twilio.voice.Utils;
import com.twilio.voice.VoiceException;
import com.twilio.voice.VoiceURLConnection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;

class EventPublisher {
    private static final Logger logger = Logger.getLogger(EventPublisher.class);
    private static final String TAG = EventPublisher.class.getSimpleName();
    private Map<EventPublisherListener, Handler> listenerMap = new HashMap<EventPublisherListener, Handler>();
    private Context context;
    private String accessToken;
    private String publisherName;
    private String homeRegion;
    String twilioProdSdkMetricsGatewayURL;
    String twilioProdSdkEventGatewayURL;
    int result = 0;
    private EventPublisherStatus eventPublisherStatus = new EventPublisherStatus();
    List<Integer> errorCodeList = Arrays.asList(403);
    @VisibleForTesting
    private EventPublisherEventListener publisherPublishEventListener;

    EventPublisher(String publisherName, String accessToken) {
        this(null, publisherName, accessToken);
    }

    EventPublisher(@Nullable Context context, String publisherName, String accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken must not be null.");
        }
        if (publisherName == null) {
            throw new NullPointerException("publisherName must not be null.");
        }
        this.context = context;
        this.accessToken = accessToken;
        this.publisherName = publisherName;
        this.twilioProdSdkMetricsGatewayURL = Constants.getKeyKibanaMetricsHostUrl();
        this.twilioProdSdkEventGatewayURL = Constants.getKeyKibanaEventGatewayHostUrl();
        try {
            this.homeRegion = new AccessTokenParser(accessToken).getHomeRegion();
        }
        catch (AccessTokenParseException e) {
            e.printStackTrace();
        }
        if (this.homeRegion != null) {
            this.updateServiceHostUrlsWithHomeRegion(this.homeRegion);
        }
    }

    private void updateServiceHostUrlsWithHomeRegion(String homeRegion) {
        this.twilioProdSdkMetricsGatewayURL = String.format("https://eventgw.%s.twilio.com/v4/EndpointMetrics", homeRegion);
        this.twilioProdSdkEventGatewayURL = String.format("https://eventgw.%s.twilio.com/v4/EndpointEvents", homeRegion);
    }

    void addListener(EventPublisherListener listener) {
        Handler handler = Utils.createHandler();
        this.listenerMap.put(listener, handler);
    }

    @VisibleForTesting
    void addEventPublisherEventListener(EventPublisherEventListener listener) {
        this.publisherPublishEventListener = listener;
    }

    void removeListener(EventPublisherListener listener) {
        this.listenerMap.remove(listener);
    }

    void publishMetrics(MetricEvent event) throws Exception {
        if (event != null) {
            JSONObject eventData = event.toJSONObject(this.context);
            this.publish(eventData.toString(), this.twilioProdSdkMetricsGatewayURL);
            if (this.publisherPublishEventListener != null) {
                this.publisherPublishEventListener.onMetricEventPublished(event);
            }
        }
    }

    MetricEvent createMetricEvent(String group, String name, JSONArray payload) {
        return new MetricEvent.Builder().productName(this.publisherName).eventName(name).groupName(group).level(Constants.SeverityLevel.INFO).payLoadType("application/json").payLoad(payload).build();
    }

    void publish(Constants.SeverityLevel level, String group, String name, Event event) throws Exception {
        if (this.publisherPublishEventListener != null && !this.eventPublisherStatus.isPublishingInvalidated()) {
            this.publisherPublishEventListener.onEventPublished(level, group, name);
        }
        JSONObject eventData = event.toJSONObject(this.context);
        this.publish(eventData.toString(), this.twilioProdSdkEventGatewayURL);
    }

    Event createEvent(Constants.SeverityLevel level, String group, String name, JSONObject payload) {
        return new Event.Builder().productName(this.publisherName).eventName(name).groupName(group).level(level).payLoadType("application/json").payLoad(payload).build();
    }

    private void publish(final String eventData, final String hostURL) {
        AsyncTask<Void, Void, Void> pushMetrics = new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... voids) {
                block8: {
                    block9: {
                        HttpsURLConnection urlConnection;
                        block7: {
                            if (EventPublisher.this.eventPublisherStatus.isPublishingInvalidated()) break block9;
                            logger.d("Start publishing events to : " + hostURL + "\n" + eventData);
                            urlConnection = null;
                            try {
                                String line;
                                urlConnection = VoiceURLConnection.create(EventPublisher.this.accessToken, hostURL, "POST");
                                OutputStreamWriter wr = new OutputStreamWriter(urlConnection.getOutputStream());
                                wr.write(eventData);
                                wr.close();
                                EventPublisher.this.result = urlConnection.getResponseCode();
                                String responseMessage = urlConnection.getResponseMessage();
                                if (EventPublisher.this.result == 200) {
                                    logger.d("Response: " + EventPublisher.this.result + " - " + responseMessage);
                                    break block7;
                                }
                                if (EventPublisher.this.errorCodeList.contains(EventPublisher.this.result)) {
                                    logger.e("Invalidating further publishing : " + EventPublisher.this.result + " - " + responseMessage);
                                    EventPublisher.this.eventPublisherStatus.invalidatePublishing(true);
                                }
                                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream()));
                                StringBuilder stringBuilder = new StringBuilder();
                                while ((line = bufferedReader.readLine()) != null) {
                                    stringBuilder.append(line);
                                    stringBuilder.append('\n');
                                }
                                bufferedReader.close();
                                String jsonString = stringBuilder.toString();
                                String explanation = EventPublisher.this.result + " - " + responseMessage + "-" + jsonString;
                                logger.d("Response: " + explanation);
                                EventPublisher.this.eventPublisherStatus.setErrorDetails(EventPublisher.this.result, responseMessage, explanation);
                                EventPublisher.this.notifyListeners(EventPublisher.this.result, responseMessage, explanation);
                            }
                            catch (Exception e) {
                                try {
                                    Log.e((String)TAG, (String)(" " + e.toString()));
                                    logger.e(e.toString());
                                }
                                catch (Throwable throwable) {
                                    VoiceURLConnection.release(urlConnection);
                                    throw throwable;
                                }
                                VoiceURLConnection.release(urlConnection);
                                break block8;
                            }
                        }
                        VoiceURLConnection.release(urlConnection);
                        break block8;
                    }
                    EventPublisher.this.notifyListeners(EventPublisher.this.result, EventPublisher.this.eventPublisherStatus.getResponseMessage(), EventPublisher.this.eventPublisherStatus.getExplanation());
                }
                return null;
            }
        };
        pushMetrics.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private void notifyListeners(final int errorCode, final String errorMessage, final String explanation) {
        for (Map.Entry<EventPublisherListener, Handler> entry : this.listenerMap.entrySet()) {
            final EventPublisherListener listener = entry.getKey();
            Handler handler = entry.getValue();
            if (handler == null) continue;
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(new VoiceException(errorCode, errorMessage, explanation){});
                    }
                }
            });
        }
    }

    @VisibleForTesting
    static interface EventPublisherEventListener {
        public void onEventPublished(Constants.SeverityLevel var1, String var2, String var3);

        public void onMetricEventPublished(MetricEvent var1);
    }

    static interface EventPublisherListener {
        public void onError(VoiceException var1);
    }

    class EventPublisherStatus {
        private volatile boolean invalidatePublishing = false;
        private int errorCode = 0;
        private String responseMessage = "";
        private String explanation;

        EventPublisherStatus() {
        }

        public boolean isPublishingInvalidated() {
            return this.invalidatePublishing;
        }

        public void invalidatePublishing(boolean invalidatePublishing) {
            this.invalidatePublishing = invalidatePublishing;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getResponseMessage() {
            return this.responseMessage;
        }

        public void setErrorDetails(int errorCode, String responseMessage, String explanation) {
            this.errorCode = errorCode;
            this.responseMessage = responseMessage;
            this.explanation = explanation;
        }

        public String getExplanation() {
            return this.explanation;
        }
    }
}

