/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.AudioCodec;
import com.twilio.voice.Call;
import com.twilio.voice.IceOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.OpusCodec;
import com.twilio.voice.PcmuCodec;
import com.twilio.voice.PlatformInfo;
import com.twilio.voice.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class CallOptions {
    private static final Set<Class> SUPPORTED_CODECS = new HashSet<Class>(Arrays.asList(OpusCodec.class, PcmuCodec.class));
    List<LocalAudioTrack> audioTracks;
    IceOptions iceOptions;
    boolean enableDscp;
    boolean enableIceGatheringOnAnyAddressPorts;
    List<AudioCodec> preferredAudioCodecs;
    PlatformInfo platformInfo;

    static void checkAudioCodecs(@NonNull List<AudioCodec> audioCodecs) {
        for (AudioCodec audioCodec : audioCodecs) {
            Preconditions.checkNotNull(audioCodec);
            Preconditions.checkArgument(SUPPORTED_CODECS.contains(audioCodec.getClass()), String.format("Unsupported audio codec %s", audioCodec.getName()));
        }
    }

    CallOptions() {
    }

    List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    @Nullable
    public IceOptions getIceOptions() {
        return this.iceOptions;
    }

    @Nullable
    public List<AudioCodec> getPreferredAudioCodecs() {
        return this.preferredAudioCodecs;
    }

    public boolean isDscpEnabled() {
        return this.enableDscp;
    }

    public boolean isIceGatheringOnAnyAddressPortsEnabled() {
        return this.enableIceGatheringOnAnyAddressPorts;
    }

    static void checkAudioTracksReleased(@Nullable List<LocalAudioTrack> audioTracks) {
        if (audioTracks != null) {
            for (LocalAudioTrack localAudioTrack : audioTracks) {
                Preconditions.checkState(!localAudioTrack.isReleased(), "LocalAudioTrack cannot be released");
            }
        }
    }

    LocalAudioTrack[] getLocalAudioTracksArray() {
        LocalAudioTrack[] audioTracksArray = new LocalAudioTrack[]{};
        if (this.audioTracks.size() > 0) {
            audioTracksArray = new LocalAudioTrack[this.audioTracks.size()];
            audioTracksArray = this.audioTracks.toArray(audioTracksArray);
        }
        return audioTracksArray;
    }

    AudioCodec[] getAudioCodecsArray() {
        AudioCodec[] audioCodecsArray = new AudioCodec[]{};
        if (this.preferredAudioCodecs != null && !this.preferredAudioCodecs.isEmpty()) {
            audioCodecsArray = new AudioCodec[this.preferredAudioCodecs.size()];
            audioCodecsArray = this.preferredAudioCodecs.toArray(audioCodecsArray);
        }
        return audioCodecsArray;
    }

    public static abstract class Builder {
        IceOptions iceOptions;
        List<LocalAudioTrack> audioTracks;
        List<AudioCodec> preferredAudioCodecs;
        boolean enableDscp = true;
        boolean enableIceGatheringOnAnyAddressPorts = false;
        Call.EventListener eventListener = null;

        Builder() {
        }

        Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "audioTracks must not be null");
            this.audioTracks = new ArrayList<LocalAudioTrack>(audioTracks);
            return this;
        }

        Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions, "iceOptions must not be null");
            this.iceOptions = iceOptions;
            return this;
        }

        Builder enableDscp(boolean enable) {
            this.enableDscp = enable;
            return this;
        }

        Builder enableIceGatheringOnAnyAddressPorts(boolean enable) {
            this.enableIceGatheringOnAnyAddressPorts = enable;
            return this;
        }

        Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs, "preferredAudioCodecs must not be null");
            this.preferredAudioCodecs = new ArrayList<AudioCodec>(preferredAudioCodecs);
            return this;
        }
    }
}

