/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.twilio.voice.Call;
import com.twilio.voice.CallException;
import com.twilio.voice.CallInvite;
import com.twilio.voice.CancelledCallInvite;
import com.twilio.voice.ConnectivityReceiver;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPayload;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InsightsUtils;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.MessageListener;
import com.twilio.voice.Preconditions;
import com.twilio.voice.ThreadUtils;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import com.twilio.voice.VoiceException;
import java.util.Map;

class CallInviteProxy
implements MessageListener {
    private static final Logger logger = Logger.getLogger(CallInviteProxy.class);
    private final ThreadUtils.ThreadChecker threadChecker;
    private final Context context;
    long nativeCallInviteProxy;
    private final Handler handler;
    private final MessageListener messageListener;
    private final MediaFactory mediaFactory;
    @Nullable
    private Call.EventListener eventListener;
    private boolean released = false;
    private ConnectivityReceiver connectivityReceiver = null;
    private Call call;
    private CallInvite callInvite;
    private String selectedRegion = Voice.region;
    private String gateway;
    private String region;
    String codecParams;
    String selectedCodec;
    private EventPublisher publisher;
    private final Call.EventListener eventListenerProxy = new Call.EventListener(){

        @Override
        public void onEvent(final Map<String, Pair<String, Class>> data) {
            CallInviteProxy.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                    logger.d("onEvent");
                    if (((String)((Pair)data.get((Object)"group")).first).equals("registration") && ((String)((Pair)data.get((Object)"name")).first).equals("unsupported-cancel-message-error")) {
                        CallInviteProxy.this.release((String)((Pair)data.get((Object)"call-sid")).first);
                    }
                    if (CallInviteProxy.this.eventListener != null) {
                        CallInviteProxy.this.eventListener.onEvent(data);
                    }
                    CallInviteProxy.this.publishEvent(data);
                }
            });
        }

        @Override
        public void onMetric(final Map<String, Pair<String, Class>> data) {
            CallInviteProxy.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                    logger.d("onMetric");
                    if (CallInviteProxy.this.eventListener != null) {
                        CallInviteProxy.this.eventListener.onMetric(data);
                    }
                    if (((String)((Pair)data.get((Object)"group")).first).equals("quality-metrics-samples")) {
                        CallInviteProxy.this.call.onSample(InsightsUtils.createRtcSample(data));
                    }
                }
            });
        }
    };

    @Override
    public void onCallInvite(final @NonNull CallInvite callInvite) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                logger.d("onCallInvite");
                Voice.callInviteProxyMap.put(callInvite.getCallSid(), CallInviteProxy.this);
                CallInviteProxy.this.registerConnectivityBroadcastReceiver();
                CallInviteProxy.this.messageListener.onCallInvite(callInvite);
            }
        });
    }

    @Override
    public void onCancelledCallInvite(final @NonNull CancelledCallInvite cancelledCallInvite, final @Nullable CallException callException) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                CallInviteProxy.this.threadChecker.checkIsOnValidThread();
                logger.d("onCancelledCallInvite: CallException code: " + (callException == null ? "null" : Integer.valueOf(callException.getErrorCode())));
                boolean wasReleased = CallInviteProxy.this.released;
                CallInviteProxy.this.release(cancelledCallInvite.getCallSid());
                if (!wasReleased) {
                    CallInviteProxy.this.messageListener.onCancelledCallInvite(cancelledCallInvite, callException);
                }
            }
        });
    }

    synchronized void setEventListener(Call.EventListener eventListener) {
        this.threadChecker.checkIsOnValidThread();
        this.eventListener = eventListener;
    }

    synchronized void setCall(Call call) {
        this.threadChecker.checkIsOnValidThread();
        this.call = call;
    }

    void networkChange(Voice.NetworkChangeEvent networkChangeEvent) {
        this.threadChecker.checkIsOnValidThread();
        if (!this.released) {
            this.nativeNetworkChange(this.nativeCallInviteProxy, networkChangeEvent);
        } else {
            logger.d("Ignoring networkChangeEvent: " + networkChangeEvent.name() + " because CallInviteProxy is released");
        }
    }

    synchronized void release(String callSid) {
        this.threadChecker.checkIsOnValidThread();
        logger.d("release");
        if (!this.released) {
            this.unregisterConnectivityBroadcastReceiver();
            Voice.callInviteProxyMap.remove(callSid);
            if (this.nativeCallInviteProxy != 0L) {
                this.nativeRelease(this.nativeCallInviteProxy);
                this.nativeCallInviteProxy = 0L;
            }
            this.mediaFactory.release(this);
            this.released = true;
        }
    }

    private CallInviteProxy(Context context, long nativeCallInviteProxy, Handler handler, MessageListener messageListener, CallInvite callInvite) {
        Preconditions.checkApplicationContext(context, "must create Call with application context");
        this.context = context;
        this.nativeCallInviteProxy = nativeCallInviteProxy;
        this.handler = handler;
        this.threadChecker = new ThreadUtils.ThreadChecker(handler.getLooper().getThread());
        this.messageListener = messageListener;
        this.mediaFactory = MediaFactory.instance(this, context);
        this.callInvite = callInvite;
        String bridgeToken = null;
        if (Voice.callSidBridgeTokenPair != null) {
            String string = bridgeToken = ((String)Voice.callSidBridgeTokenPair.first).equals(callInvite.getCallSid()) ? (String)Voice.callSidBridgeTokenPair.second : null;
        }
        if (bridgeToken != null) {
            this.publisher = new EventPublisher(context, "twilio-voice-android", bridgeToken);
            this.publisher.addListener(new EventPublisher.EventPublisherListener(){

                @Override
                public void onError(VoiceException voiceException) {
                    logger.e("Error publishing data : " + voiceException.getMessage() + ":" + voiceException.getErrorCode());
                }
            });
        }
    }

    private void registerConnectivityBroadcastReceiver() {
        this.connectivityReceiver = new ConnectivityReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void unregisterConnectivityBroadcastReceiver() {
        if (this.connectivityReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
        }
    }

    private void publishEvent(Map<String, Pair<String, Class>> data) {
        if (((String)data.get((Object)"group").first).equals("settings")) {
            if (((String)data.get((Object)"name").first).equals("codec")) {
                this.codecParams = (String)data.get((Object)"codec_params").first;
                this.selectedCodec = (String)data.get((Object)"selected_codec").first;
            } else if (((String)data.get((Object)"name").first).equals("edge")) {
                this.gateway = (String)data.get((Object)"edge-host-name").first;
                this.region = (String)data.get((Object)"edge").first;
            }
            InsightsUtils.processEvent(data, this.createEventPayloadBuilderForSettingsEvent(), this.publisher, Constants.Direction.INCOMING);
        } else {
            InsightsUtils.processEvent(data, this.createEventPayloadBuilder(), this.publisher, Constants.Direction.INCOMING);
        }
    }

    private EventPayload.Builder createEventPayloadBuilder() {
        return new EventPayload.Builder().callSid(this.callInvite.getCallSid()).messageSid(this.callInvite.getMessageSid()).direction(Constants.Direction.INCOMING).selectedRegion(this.selectedRegion).gateway(this.gateway).region(this.region).productName("twilio-voice-android").clientName(Utils.parseClientIdentity(this.callInvite.getTo())).payLoadType("application/json");
    }

    EventPayload.Builder createEventPayloadBuilderForSettingsEvent() {
        return this.createEventPayloadBuilder().codecParams(this.codecParams).selectedCodec(this.selectedCodec);
    }

    private native void nativeNetworkChange(long var1, Voice.NetworkChangeEvent var3);

    private native void nativeRelease(long var1);
}

