/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Handler;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.AcceptOptions;
import com.twilio.voice.CallException;
import com.twilio.voice.CallInvite;
import com.twilio.voice.ConnectOptions;
import com.twilio.voice.ConnectivityReceiver;
import com.twilio.voice.Constants;
import com.twilio.voice.EventPublisher;
import com.twilio.voice.InsightsUtils;
import com.twilio.voice.InternalCall;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.Logger;
import com.twilio.voice.MediaFactory;
import com.twilio.voice.Preconditions;
import com.twilio.voice.StatsListener;
import com.twilio.voice.StatsReport;
import com.twilio.voice.ThreadUtils;
import com.twilio.voice.Utils;
import com.twilio.voice.Voice;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import tvo.webrtc.voiceengine.WebRtcAudioManager;

public class Call
extends InternalCall {
    private static final Field blacklistDeviceForOpenSLESUsageField;
    private static final Field blacklistDeviceForOpenSLESUsageIsOverriddenField;
    private final ThreadUtils.ThreadChecker threadChecker;
    private Listener listener;
    private EventListener eventListener;
    private static final Logger logger;
    private List<LocalAudioTrack> localAudioTracks = Collections.emptyList();
    private MediaFactory mediaFactory;
    private long nativeCallDelegate;
    private Queue<Pair<Handler, StatsListener>> statsListenersQueue;
    private ConnectivityReceiver connectivityReceiver = null;
    private Set<CallQualityWarning> currentCallQualityWarning;
    private final Listener callListenerProxy = new Listener(){

        @Override
        public void onRinging(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onRinging()");
                    Call.this.state = State.RINGING;
                    call.sid = Call.this.nativeGetSid(Call.this.nativeCallDelegate);
                    Call.this.listener.onRinging(call);
                }
            });
        }

        @Override
        public void onConnected(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onConnected()");
                    Call.this.state = State.CONNECTED;
                    call.sid = Call.this.nativeGetSid(Call.this.nativeCallDelegate);
                    Call.this.listener.onConnected(call);
                }
            });
        }

        @Override
        public void onReconnecting(final @NonNull Call call, final @NonNull CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onReconnecting()");
                    Call.this.state = State.RECONNECTING;
                    Call.this.listener.onReconnecting(call, callException);
                }
            });
        }

        @Override
        public void onReconnected(final @NonNull Call call) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onReconnected()");
                    Call.this.state = State.CONNECTED;
                    Call.this.listener.onReconnected(call);
                }
            });
        }

        @Override
        public void onConnectFailure(final @NonNull Call call, final @NonNull CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.releaseCall();
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onConnectFailure()");
                    Call.this.unregisterConnectivityBroadcastReceiver(Call.this.context);
                    Voice.calls.remove(Call.this);
                    Voice.rejects.remove(Call.this);
                    Call.this.state = State.DISCONNECTED;
                    Call.this.release();
                    Call.this.listener.onConnectFailure(call, callException);
                }
            });
        }

        @Override
        public void onDisconnected(final @NonNull Call call, final CallException callException) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.releaseCall();
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onDisconnected()");
                    Call.this.unregisterConnectivityBroadcastReceiver(Call.this.context);
                    Voice.calls.remove(Call.this);
                    Voice.rejects.remove(Call.this);
                    Call.this.state = State.DISCONNECTED;
                    Call.this.release();
                    Call.this.listener.onDisconnected(call, callException);
                }
            });
        }

        @Override
        public void onCallQualityWarningsChanged(final Call call, final Set<CallQualityWarning> currentWarnings, final Set<CallQualityWarning> previousWarnings) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Call.this.threadChecker.checkIsOnValidThread();
                    logger.d("onCallQualityWarningsChanged()");
                    Call.this.currentCallQualityWarning = currentWarnings;
                    Call.this.listener.onCallQualityWarningsChanged(call, currentWarnings, previousWarnings);
                }
            });
        }
    };
    EventListener eventListenerProxy = new EventListener(){

        @Override
        public void onEvent(final Map<String, Pair<String, Class>> data) {
            Call.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (Call.this.eventListener != null) {
                        Call.this.eventListener.onEvent(data);
                    }
                    if (((String)((Pair)data.get((Object)"group")).first).equals("audio-level-warning-raised") || ((String)((Pair)data.get((Object)"group")).first).equals("network-quality-warning-raised")) {
                        InsightsUtils.processWarningEvent(data, Call.this.createEventPayloadBuilder(), Call.this.publisher);
                    } else {
                        if (((String)((Pair)data.get((Object)"group")).first).equals("connection") && ((String)((Pair)data.get((Object)"name")).first).equals("ringing")) {
                            Call.this.sid = (String)((Pair)data.get((Object)"call-sid")).first;
                        }
                        if (((String)((Pair)data.get((Object)"group")).first).equals("settings")) {
                            if (((String)((Pair)data.get((Object)"name")).first).equals("codec")) {
                                Call.this.codecParams = (String)((Pair)data.get((Object)"codec_params")).first;
                                Call.this.selectedCodec = (String)((Pair)data.get((Object)"selected_codec")).first;
                            } else if (((String)((Pair)data.get((Object)"name")).first).equals("edge")) {
                                Call.this.gateway = (String)((Pair)data.get((Object)"edge-host-name")).first;
                                Call.this.region = (String)((Pair)data.get((Object)"edge")).first;
                            }
                            InsightsUtils.processEvent(data, Call.this.createEventPayloadBuilderForSettingsEvent(), Call.this.publisher, Call.this.direction);
                        } else {
                            InsightsUtils.processEvent(data, Call.this.createEventPayloadBuilder(), Call.this.publisher, Call.this.direction);
                        }
                    }
                }
            });
        }

        @Override
        public void onMetric(Map<String, Pair<String, Class>> data) {
            if (Call.this.eventListener != null) {
                Call.this.eventListener.onMetric(data);
            }
            if (((String)data.get((Object)"group").first).equals("quality-metrics-samples")) {
                Call.this.onSample(InsightsUtils.createRtcSample(data));
            }
        }
    };
    private final StatsListener statsListenerProxy = new StatsListener(){

        @Override
        public void onStats(final List<StatsReport> statsReports) {
            final Pair<Handler, StatsListener> statsPair = Call.this.statsListenersQueue.poll();
            if (statsPair != null) {
                ((Handler)statsPair.first).post(new Runnable(){

                    @Override
                    public void run() {
                        ((StatsListener)statsPair.second).onStats(statsReports);
                    }
                });
            }
        }
    };

    Call(Context context, CallInvite callInvite, Listener listener) {
        Preconditions.checkApplicationContext(context, "must create Call with application context");
        this.context = context;
        this.listener = listener;
        this.from = callInvite.getFrom();
        this.to = callInvite.getTo();
        this.sid = callInvite.getCallSid();
        this.bridgeToken = callInvite.getBridgeToken();
        this.disconnectCalled = false;
        this.direction = Constants.Direction.INCOMING;
        this.handler = Utils.createHandler();
        this.threadChecker = new ThreadUtils.ThreadChecker(this.handler.getLooper().getThread());
        this.state = State.CONNECTING;
        this.publisher = new EventPublisher(context, "twilio-voice-android", this.bridgeToken);
        this.publisher.addListener(this);
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
        Call.configureOpenSLES();
    }

    Call(Context context, String accessToken, Listener listener) {
        Preconditions.checkApplicationContext(context, "must create Call with application context");
        this.context = context;
        this.listener = listener;
        this.state = State.CONNECTING;
        this.direction = Constants.Direction.OUTGOING;
        this.handler = Utils.createHandler();
        this.threadChecker = new ThreadUtils.ThreadChecker(this.handler.getLooper().getThread());
        this.publisher = new EventPublisher(context, "twilio-voice-android", accessToken);
        this.publisher.addListener(this);
        this.statsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, StatsListener>>();
        Call.configureOpenSLES();
    }

    @Nullable
    public String getFrom() {
        return this.from;
    }

    @Nullable
    public String getTo() {
        return this.to;
    }

    @Override
    @Nullable
    public String getSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public State getState() {
        return this.state;
    }

    public synchronized void getStats(@NonNull StatsListener statsListener) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkNotNull(statsListener, "statsListener must not be null");
        if (this.state == State.DISCONNECTED) {
            return;
        }
        this.statsListenersQueue.offer((Pair<Handler, StatsListener>)new Pair((Object)Utils.createHandler(), (Object)statsListener));
        this.nativeGetStats(this.nativeCallDelegate);
    }

    public Set<CallQualityWarning> getCallQualityWarnings() {
        return this.currentCallQualityWarning;
    }

    public void postFeedback(@NonNull Score score, @NonNull Issue issue) {
        Preconditions.checkNotNull(score, "score must not be null");
        Preconditions.checkNotNull(issue, "issue must not be null");
        this.publishFeedbackEvent(score, issue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ConnectOptions connectOptions) {
        this.threadChecker.checkIsOnValidThread();
        this.registerConnectivityBroadcastReceiver(this.context);
        Voice.calls.add(this);
        ConnectOptions.checkAudioTracksReleased(connectOptions.getAudioTracks());
        this.localAudioTracks = connectOptions.getAudioTracks();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            if (connectOptions.getEventListener() != null) {
                this.eventListener = connectOptions.getEventListener();
            }
            this.nativeCallDelegate = this.nativeConnect(connectOptions, this.callListenerProxy, this.statsListenerProxy, this.eventListenerProxy, this.mediaFactory.getNativeMediaFactoryHandle(), this.handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(AcceptOptions acceptOptions, long nativeCallInviteProxy) {
        this.threadChecker.checkIsOnValidThread();
        this.registerConnectivityBroadcastReceiver(this.context);
        Voice.calls.add(this);
        AcceptOptions.checkAudioTracksReleased(acceptOptions.getAudioTracks());
        this.localAudioTracks = acceptOptions.getAudioTracks();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            this.nativeCallDelegate = this.nativeAccept(acceptOptions, this.callListenerProxy, this.statsListenerProxy, this.eventListenerProxy, this.handler, nativeCallInviteProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reject(AcceptOptions acceptOptions, long nativeCallInviteProxy) {
        this.threadChecker.checkIsOnValidThread();
        this.registerConnectivityBroadcastReceiver(this.context);
        Voice.rejects.add(this);
        this.localAudioTracks = acceptOptions.getAudioTracks();
        Listener listener = this.callListenerProxy;
        synchronized (listener) {
            Voice.loadLibrary(this.context);
            this.mediaFactory = MediaFactory.instance(this, this.context);
            this.nativeCallDelegate = this.nativeReject(acceptOptions, this.callListenerProxy, this.eventListenerProxy, this.handler, nativeCallInviteProxy);
        }
    }

    @Override
    public synchronized void mute(boolean mute) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState()) {
            this.isMuted = mute;
            this.nativeMute(this.nativeCallDelegate, mute);
        }
    }

    @Override
    public synchronized void sendDigits(@NonNull String digits) {
        this.threadChecker.checkIsOnValidThread();
        Preconditions.checkNotNull(digits, "digits must not be null");
        if (!digits.matches("^[0-9\\*\\#w]+$")) {
            throw new IllegalArgumentException("digits string must not be null and should only contains 0-9, *, #, or w characters");
        }
        if (this.isValidState()) {
            this.nativeSendDigits(this.nativeCallDelegate, digits);
        }
    }

    public synchronized void hold(boolean hold) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState()) {
            this.isOnHold = hold;
            this.nativeHold(this.nativeCallDelegate, hold);
        }
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    public boolean isOnHold() {
        return this.isOnHold;
    }

    @Override
    public synchronized void disconnect() {
        this.threadChecker.checkIsOnValidThread();
        if (!this.disconnectCalled && this.isValidState() && this.nativeCallDelegate != 0L) {
            this.disconnectCalled = true;
            logger.d("Calling disconnect " + (Object)((Object)this.state));
            this.nativeDisconnect(this.nativeCallDelegate);
        }
    }

    void networkChange(Voice.NetworkChangeEvent networkChangeEvent) {
        this.threadChecker.checkIsOnValidThread();
        if (this.isValidState() && this.isPermittedNetworkChangeEvent(networkChangeEvent)) {
            this.nativeNetworkChange(this.nativeCallDelegate, networkChangeEvent);
        } else {
            logger.d("Ignoring networkChangeEvent: " + networkChangeEvent.name() + " in Call.State: " + (Object)((Object)this.state));
        }
    }

    synchronized void release() {
        this.threadChecker.checkIsOnValidThread();
        for (LocalAudioTrack localAudioTrack : this.localAudioTracks) {
            localAudioTrack.release();
        }
        if (this.nativeCallDelegate != 0L) {
            this.nativeRelease(this.nativeCallDelegate);
            this.nativeCallDelegate = 0L;
            if (this.mediaFactory != null) {
                this.mediaFactory.release(this);
            }
        }
    }

    @VisibleForTesting
    static void configureOpenSLES() {
        if (!Call.openSLESEnabled()) {
            WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage((boolean)true);
        }
    }

    @VisibleForTesting
    static boolean openSLESEnabled() {
        try {
            return (Boolean)blacklistDeviceForOpenSLESUsageField.get(null) == false && (Boolean)blacklistDeviceForOpenSLESUsageIsOverriddenField.get(null) != false;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine if OpenSLES is enabled.");
        }
    }

    private void registerConnectivityBroadcastReceiver(Context context) {
        this.connectivityReceiver = new ConnectivityReceiver();
        context.registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private boolean isPermittedNetworkChangeEvent(Voice.NetworkChangeEvent networkChangeEvent) {
        return networkChangeEvent != Voice.NetworkChangeEvent.CONNECTION_CHANGED || this.state != State.CONNECTING && this.state != State.RINGING;
    }

    private void unregisterConnectivityBroadcastReceiver(Context context) {
        context.unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
        this.connectivityReceiver = null;
    }

    private synchronized void releaseCall() {
        if (this.nativeCallDelegate != 0L) {
            this.nativeReleaseCall(this.nativeCallDelegate);
        }
    }

    private native long nativeConnect(ConnectOptions var1, Listener var2, StatsListener var3, EventListener var4, long var5, Handler var7);

    private native long nativeAccept(AcceptOptions var1, Listener var2, StatsListener var3, EventListener var4, Handler var5, long var6);

    private native long nativeReject(AcceptOptions var1, Listener var2, EventListener var3, Handler var4, long var5);

    private native String nativeGetSid(long var1);

    private native void nativeGetStats(long var1);

    private native void nativeMute(long var1, boolean var3);

    private native void nativeSendDigits(long var1, String var3);

    private native void nativeHold(long var1, boolean var3);

    private native void nativeDisconnect(long var1);

    private native void nativeNetworkChange(long var1, Voice.NetworkChangeEvent var3);

    private native void nativeReleaseCall(long var1);

    private native void nativeRelease(long var1);

    static {
        try {
            blacklistDeviceForOpenSLESUsageField = WebRtcAudioManager.class.getDeclaredField("blacklistDeviceForOpenSLESUsage");
            blacklistDeviceForOpenSLESUsageIsOverriddenField = WebRtcAudioManager.class.getDeclaredField("blacklistDeviceForOpenSLESUsageIsOverridden");
            blacklistDeviceForOpenSLESUsageField.setAccessible(true);
            blacklistDeviceForOpenSLESUsageIsOverriddenField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.getMessage());
        }
        logger = Logger.getLogger(Call.class);
    }

    static interface EventListener {
        public void onEvent(Map<String, Pair<String, Class>> var1);

        public void onMetric(Map<String, Pair<String, Class>> var1);
    }

    public static interface Listener {
        public void onConnectFailure(@NonNull Call var1, @NonNull CallException var2);

        public void onRinging(@NonNull Call var1);

        public void onConnected(@NonNull Call var1);

        public void onReconnecting(@NonNull Call var1, @NonNull CallException var2);

        public void onReconnected(@NonNull Call var1);

        public void onDisconnected(@NonNull Call var1, @Nullable CallException var2);

        default public void onCallQualityWarningsChanged(@NonNull Call call, @NonNull Set<CallQualityWarning> currentWarnings, @NonNull Set<CallQualityWarning> previousWarnings) {
        }
    }

    public static enum State {
        CONNECTING,
        RINGING,
        CONNECTED,
        RECONNECTING,
        DISCONNECTED;

    }

    public static enum CallQualityWarning {
        WARN_HIGH_RTT("high-rtt"),
        WARN_HIGH_JITTER("high-jitter"),
        WARN_HIGH_PACKET_LOSS("high-packet-loss"),
        WARN_LOW_MOS("low-mos"),
        WARN_CONSTANT_AUDIO_IN_LEVEL("constant-audio-input-level");

        private final String warningName;

        private CallQualityWarning(String warningName) {
            this.warningName = warningName;
        }

        public String toString() {
            return this.warningName;
        }

        public static CallQualityWarning fromString(String warningName) {
            if (warningName.equals(CallQualityWarning.WARN_HIGH_RTT.warningName)) {
                return WARN_HIGH_RTT;
            }
            if (warningName.equals(CallQualityWarning.WARN_HIGH_JITTER.warningName)) {
                return WARN_HIGH_JITTER;
            }
            if (warningName.equals(CallQualityWarning.WARN_HIGH_PACKET_LOSS.warningName)) {
                return WARN_HIGH_PACKET_LOSS;
            }
            if (warningName.equals(CallQualityWarning.WARN_LOW_MOS.warningName)) {
                return WARN_LOW_MOS;
            }
            if (warningName.equals(CallQualityWarning.WARN_CONSTANT_AUDIO_IN_LEVEL.warningName)) {
                return WARN_CONSTANT_AUDIO_IN_LEVEL;
            }
            throw new RuntimeException("Unsupported warning name string -> " + warningName);
        }
    }

    public static enum Issue {
        NOT_REPORTED("not-reported"),
        DROPPED_CALL("dropped-call"),
        AUDIO_LATENCY("audio-latency"),
        ONE_WAY_AUDIO("one-way-audio"),
        CHOPPY_AUDIO("choppy-audio"),
        NOISY_CALL("noisy-call"),
        ECHO("echo");

        private final String issueName;

        private Issue(String issueName) {
            this.issueName = issueName;
        }

        public String toString() {
            return this.issueName;
        }
    }

    public static enum Score {
        NOT_REPORTED(0),
        ONE(1),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5);

        private final int score;

        private Score(int score) {
            this.score = score;
        }

        public int getValue() {
            return this.score;
        }
    }
}

