/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.util.Base64;
import com.twilio.voice.AccessTokenParseException;
import com.twilio.voice.Logger;
import java.util.HashMap;

class AccessTokenParser {
    private static final Logger logger = Logger.getLogger(AccessTokenParser.class);
    final String twilioVoiceHomeRegionSpecifier = "twr";
    final int numberOfSegmentsInAccessToken = 3;
    final int numberOfSegmentsInridgeToken = 5;
    String rawToken = null;
    String homeRegion;

    AccessTokenParser(String inToken) throws AccessTokenParseException {
        this.parse(inToken);
    }

    String getHomeRegion() {
        return this.homeRegion;
    }

    void parse(String inToken) throws AccessTokenParseException {
        this.rawToken = inToken;
        if (this.rawToken != null) {
            String[] parts = this.rawToken.trim().split("\\.");
            if (parts.length != 3 && parts.length != 5) {
                throw new AccessTokenParseException("Access token must have 3 or 5 segments");
            }
            for (int i = 0; i < parts.length; ++i) {
                byte[] decodedBytes = Base64.decode((byte[])parts[i].getBytes(), (int)8);
                parts[i] = new String(decodedBytes);
            }
            this.extractHeader(parts[0]);
        }
    }

    void extractHeader(String inHeader) {
        logger.i("JWT token HEADER: " + inHeader);
        String header = inHeader.replace("{", "").replace("}", "");
        String[] tokens = header.split(",");
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (int i = 0; i < tokens.length; ++i) {
            String[] headers = tokens[i].split(":");
            headersMap.put(headers[0].replace("\"", ""), headers[1].replace("\"", ""));
        }
        this.homeRegion = (String)headersMap.get("twr");
    }
}

