package com.twilio.voice;

final class PlatformInfo {
    private static final String PLATFORM_NAME = "Android";
    private String platformVersion;
    private String hwDeviceManufacturer;
    private String hwDeviceModel;
    private String sdkVersion;
    private String hwDeviceArch;

    public PlatformInfo() {
        this.platformVersion = android.os.Build.VERSION.RELEASE;
        this.hwDeviceManufacturer = android.os.Build.MANUFACTURER;
        this.hwDeviceModel = android.os.Build.MODEL;
        this.sdkVersion = Voice.getVersion();
        this.hwDeviceArch = System.getProperty("os.arch");
    }

    public String getPlatformName() {
        return PLATFORM_NAME;
    }

    public String getPlatformVersion() {
        return platformVersion;
    }

    public String getHwDeviceManufacturer() {
        return hwDeviceManufacturer;
    }

    public String getHwDeviceModel() {
        return hwDeviceModel;
    }

    public String getSdkVersion() {
        return sdkVersion;
    }

    public String getHwDeviceArch() {
        return hwDeviceArch;
    }
}
