package com.twilio.voice;

class MonitorThresholds {

    private int minMosScoreThreshhold;
    private int maxDurationConstantAudioInputLevel;
    private int maxDurationConstantAudioOutputLevel;
    private int maxPacketsLostFraction;
    private int maxJitterThreshold;
    private int maxRttThreshold;

    private MonitorThresholds(Builder builder) {
        this.minMosScoreThreshhold = builder.minMosScoreThreshhold;
        this.maxDurationConstantAudioOutputLevel = builder.maxDurationConstantAudioOutputLevel;
        this.maxDurationConstantAudioInputLevel = builder.maxDurationConstantAudioInputLevel;
        this.maxPacketsLostFraction = builder.maxPacketsLostFraction;
        this.maxJitterThreshold = builder.maxJitterThreshold;
        this.maxRttThreshold = builder.maxRttThreshold;
    }

    int getMinMosScoreThreshhold() {
        return minMosScoreThreshhold;
    }

    int getMaxDurationConstantAudioInputLevel() {
        return maxDurationConstantAudioInputLevel;
    }

    int getMaxDurationConstantAudioOutputLevel() {
        return maxDurationConstantAudioOutputLevel;
    }

    int getMaxPacketsLostFraction() {
        return maxPacketsLostFraction;
    }

    int getMaxJitterThreshold() {
        return maxJitterThreshold;
    }

    int getMaxRttThreshold() {
        return maxRttThreshold;
    }

    static class Builder {

        private int minMosScoreThreshhold = -1;
        private int maxDurationConstantAudioInputLevel = -1;
        private int maxDurationConstantAudioOutputLevel = -1;
        private int maxPacketsLostFraction = -1;
        private int maxJitterThreshold = -1;
        private int maxRttThreshold = -1;

        Builder() {
        }

        Builder mosScoreThreshhold(int mosScoreThreshhold) {
            this.minMosScoreThreshhold = mosScoreThreshhold;
            return this;
        }

        Builder audioConstantInputLevelSampleCounter(int audioConstantInputLevelSampleCounter) {
            this.maxDurationConstantAudioInputLevel = audioConstantInputLevelSampleCounter;
            return this;
        }

        Builder audioConstantOutputLevelSampleCounter(int audioConstantOutputLevelSampleCounter) {
            this.maxDurationConstantAudioOutputLevel = audioConstantOutputLevelSampleCounter;
            return this;
        }

        Builder packetsLostFraction(int packetsLostFraction) {
            this.maxPacketsLostFraction = packetsLostFraction;
            return this;
        }

        Builder jitterThreshold(int jitterThreshold) {
            this.maxJitterThreshold = jitterThreshold;
            return this;
        }

        Builder rttThreshold(int rttThreshold) {
            this.maxRttThreshold = rttThreshold;
            return this;
        }

        MonitorThresholds build() {
            return new MonitorThresholds(this);
        }
    }
}
