package com.twilio.voice;

import androidx.annotation.NonNull;

/**
 * IceServer is a single STUN or TURN server.
 */
public class IceServer {
    public final String username;
    public final String password;
    public final String serverUrl;

    public IceServer(@NonNull String serverUrl) {
        this(serverUrl, "", "");
    }

    public IceServer(@NonNull String serverUrl,
                     @NonNull String username,
                     @NonNull String password) {
        this.username = username;
        this.password = password;
        this.serverUrl = serverUrl;
    }
}
