package com.twilio.voice;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * AudioDeviceRenderer interface provides the mechanism to define a custom audio device renderer.
 */
public interface AudioDeviceRenderer {

    /**
     * Returns the format of the audio that will be rendered. Returning `null` indicates rendering
     * is not supported.
     *
     * @return {@link com.twilio.voice.AudioFormat}
     */
    @Nullable
    AudioFormat getRendererFormat();

    /**
     * Raised when the Renderer is ready to be initialized. This method is called before {@link #onStartRendering(AudioDeviceContext)}.
     *
     * @return A boolean value to indicate if initialization was successful.
     */
    boolean onInitRenderer();

    /**
     * Raised when the renderer is ready to render.
     *
     * @param audioDeviceContext
     * @return A boolean value that indicates if rendering has started or not.
     */
    boolean onStartRendering(@NonNull AudioDeviceContext audioDeviceContext);

    /**
     * Raised when the capturer stops rendering.
     *
     * @return A boolean value that indicates if rendering has stopped or not.
     */
    boolean onStopRendering();
}
