package com.twilio.video;

class VideoSinkHintsConsumer {
    private static final Logger logger = Logger.getLogger(VideoSinkHintsConsumer.class);
    static final long MANUAL_SINK_HINTS_ID = -1;
    static final long NO_ATTACHED_SINK_HINTS_ID = 0;
    static final long CUSTOM_SINK_HINTS_ID = 1;
    private long sinkHintsIdCount = 2;
    private final boolean videoContentPreferencesAutoModeEnabled;
    private final boolean clientTrackSwitchAutoModeEnabled;
    final ConsumeSinkHintsListener consumeSinkHintsListener;

    VideoSinkHintsConsumer(
            boolean videoContentPreferencesAutoModeEnabled,
            boolean clientTrackSwitchAutoModeEnabled,
            ConsumeSinkHintsListener consumeSinkHintsListener) {

        this.videoContentPreferencesAutoModeEnabled = videoContentPreferencesAutoModeEnabled;
        this.clientTrackSwitchAutoModeEnabled = clientTrackSwitchAutoModeEnabled;
        this.consumeSinkHintsListener = consumeSinkHintsListener;
    }

    void consumeSinkHints(SinkHints sinkHints) {
        logger.d("Consuming SinkHints = " + sinkHints);
        consumeSinkHintsListener.consumeSinkHints(sinkHints);
    }

    Long getNextSinkHintsId() {
        return sinkHintsIdCount++;
    }

    interface ConsumeSinkHintsListener {
        void consumeSinkHints(SinkHints sinkHints);
    }

    boolean isVideoContentPreferencesAutoModeEnabled() {
        return videoContentPreferencesAutoModeEnabled;
    }

    boolean isClientTrackSwitchAutoModeEnabled() {
        return clientTrackSwitchAutoModeEnabled;
    }
}
