/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.getkeepsafe.relinker.ReLinker;
import com.twilio.video.AudioDevice;
import com.twilio.video.ConnectOptions;
import com.twilio.video.DefaultAudioDevice;
import com.twilio.video.LogLevel;
import com.twilio.video.LogModule;
import com.twilio.video.Logger;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteParticipant;
import com.twilio.video.Room;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public abstract class Video {
    private static LogLevel level = LogLevel.OFF;
    @VisibleForTesting
    static Map<LogModule, LogLevel> moduleLogLevel = new EnumMap<LogModule, LogLevel>(LogModule.class);
    private static volatile boolean libraryIsLoaded = false;
    private static final Logger logger = Logger.getLogger(Video.class);
    private static final LogLevel defaultLogLevel = LogLevel.ERROR;
    @VisibleForTesting
    static final Set<Room> rooms = new HashSet<Room>();
    private static NetworkInfo currentNetworkInfo = null;
    private static Context applicationContext = null;
    private static AudioDevice audioDevice;
    private static final BroadcastReceiver connectivityChangeReceiver;

    @NonNull
    public static synchronized Room connect(@NonNull Context context, @NonNull ConnectOptions connectOptions, @NonNull Room.Listener roomListener) {
        logger.d("Video.connect");
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(connectOptions, "connectOptions must not be null");
        Preconditions.checkNotNull(roomListener, "roomListener must not be null");
        if (applicationContext == null) {
            applicationContext = context.getApplicationContext();
        }
        if (!libraryIsLoaded) {
            ReLinker.loadLibrary((Context)applicationContext, (String)"twilio_video_android_so");
            libraryIsLoaded = true;
            Video.trySetCoreLogLevel(level.ordinal());
            for (LogModule module : moduleLogLevel.keySet()) {
                Video.trySetCoreModuleLogLevel(module.ordinal(), moduleLogLevel.get((Object)module).ordinal());
            }
        }
        if (rooms.isEmpty()) {
            ConnectivityManager conn = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            currentNetworkInfo = conn.getActiveNetworkInfo();
            Video.registerConnectivityBroadcastReceiver();
        }
        Room room = new Room(applicationContext, connectOptions.getRoomName(), Util.createCallbackHandler(), Video.roomListenerProxy(roomListener));
        room.connect(connectOptions);
        rooms.add(room);
        return room;
    }

    static synchronized void release(Room room) {
        logger.d("Video.release");
        rooms.remove(room);
        if (rooms.isEmpty()) {
            logger.d("Last room released, unregistering for connectivity events");
            Video.unregisterConnectivityBroadcastReceiver();
            PlatformInfo.release();
        }
    }

    private static synchronized void onNetworkChange(NetworkChangeEvent networkChangeEvent) {
        logger.d("Video.onNetworkChange");
        for (Room room : rooms) {
            room.onNetworkChanged(networkChangeEvent);
        }
    }

    private static Room.Listener roomListenerProxy(final Room.Listener roomListener) {
        return new Room.Listener(){

            @Override
            public void onConnected(@NonNull Room room) {
                logger.d("RoomListenerProxy.onConnected");
                roomListener.onConnected(room);
            }

            @Override
            public void onConnectFailure(@NonNull Room room, @NonNull TwilioException twilioException) {
                logger.d("RoomListenerProxy.onConnectFailure");
                Video.release(room);
                roomListener.onConnectFailure(room, twilioException);
            }

            @Override
            public void onReconnecting(@NonNull Room room, @NonNull TwilioException twilioException) {
                logger.d("RoomListenerProxy.onReconnecting");
                roomListener.onReconnecting(room, twilioException);
            }

            @Override
            public void onReconnected(@NonNull Room room) {
                logger.d("RoomListenerProxy.onReconnected");
                roomListener.onReconnected(room);
            }

            @Override
            public void onDisconnected(@NonNull Room room, @Nullable TwilioException twilioException) {
                logger.d("RoomListenerProxy.onDisconnected");
                Video.release(room);
                roomListener.onDisconnected(room, twilioException);
            }

            @Override
            public void onParticipantConnected(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
                logger.d("RoomListenerProxy.onParticipantConnected");
                roomListener.onParticipantConnected(room, remoteParticipant);
            }

            @Override
            public void onParticipantDisconnected(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
                logger.d("RoomListenerProxy.onParticipantDisconnected");
                roomListener.onParticipantDisconnected(room, remoteParticipant);
            }

            @Override
            public void onParticipantReconnecting(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
                logger.d("RoomListenerProxy.onParticipantReconnecting");
                roomListener.onParticipantReconnecting(room, remoteParticipant);
            }

            @Override
            public void onParticipantReconnected(@NonNull Room room, @NonNull RemoteParticipant remoteParticipant) {
                logger.d("RoomListenerProxy.onParticipantReconnected");
                roomListener.onParticipantReconnected(room, remoteParticipant);
            }

            @Override
            public void onDominantSpeakerChanged(@NonNull Room room, @Nullable RemoteParticipant remoteParticipant) {
                logger.d("RoomListenerProxy.onDominantSpeakerChanged");
                roomListener.onDominantSpeakerChanged(room, remoteParticipant);
            }

            @Override
            public void onRecordingStarted(@NonNull Room room) {
                logger.d("RoomListenerProxy.onRecordingStarted");
                roomListener.onRecordingStarted(room);
            }

            @Override
            public void onRecordingStopped(@NonNull Room room) {
                logger.d("RoomListenerProxy.onRecordingStopped");
                roomListener.onRecordingStopped(room);
            }

            @Override
            public void onTranscription(@NonNull Room room, @NonNull JSONObject json) {
                logger.d("RoomListenerProxy.onTranscription");
                roomListener.onTranscription(room, json);
            }
        };
    }

    @NonNull
    public static String getVersion() {
        return "7.10.0";
    }

    @NonNull
    public static LogLevel getLogLevel() {
        return LogLevel.values()[Video.tryGetCoreLogLevel()];
    }

    @NonNull
    public static LogLevel getModuleLogLevel(LogModule module) {
        if (moduleLogLevel.containsKey((Object)module)) {
            return moduleLogLevel.get((Object)module);
        }
        return defaultLogLevel;
    }

    @NonNull
    public static AudioDevice getAudioDevice() {
        if (audioDevice == null) {
            logger.d("Creating default audio device.");
            audioDevice = new DefaultAudioDevice();
        }
        return audioDevice;
    }

    public static synchronized void setAudioDevice(@NonNull AudioDevice audioDevice) throws UnsupportedOperationException {
        logger.d("Video.setAudioDevice");
        Preconditions.checkNotNull(audioDevice, "audioDevice must not be null");
        if (!rooms.isEmpty()) {
            logger.e("Cannot set audio device, rooms are still connected: " + rooms.toString());
            throw new UnsupportedOperationException("Changing the audio device while connected to a room is not allowed ");
        }
        Video.audioDevice = audioDevice;
    }

    public static void setLogLevel(@NonNull LogLevel level) {
        Preconditions.checkNotNull(level, "LogLevel should not be null");
        logger.d("Video.setLogLevel: " + level.toString());
        Video.setSDKLogLevel(level);
        Video.trySetCoreLogLevel(level.ordinal());
        Video.level = level;
    }

    public static void setModuleLogLevel(@NonNull LogModule module, @NonNull LogLevel level) {
        Preconditions.checkNotNull(module, "LogModule should not be null");
        Preconditions.checkNotNull(level, "LogLevel should not be null");
        if (module == LogModule.PLATFORM) {
            Video.setSDKLogLevel(level);
        }
        Video.trySetCoreModuleLogLevel(module.ordinal(), level.ordinal());
        moduleLogLevel.put(module, level);
    }

    private static void setSDKLogLevel(LogLevel level) {
        switch (level) {
            case OFF: {
                Logger.setLogLevel(7);
                break;
            }
            case FATAL: {
                Logger.setLogLevel(6);
                break;
            }
            case ERROR: {
                Logger.setLogLevel(6);
                break;
            }
            case WARNING: {
                Logger.setLogLevel(5);
                break;
            }
            case INFO: {
                Logger.setLogLevel(4);
                break;
            }
            case DEBUG: {
                Logger.setLogLevel(3);
                break;
            }
            case TRACE: {
                Logger.setLogLevel(2);
                break;
            }
            case ALL: {
                Logger.setLogLevel(2);
                break;
            }
            default: {
                Logger.setLogLevel(7);
            }
        }
    }

    private static void trySetCoreLogLevel(int level) {
        if (libraryIsLoaded) {
            Video.nativeSetCoreLogLevel(level);
        }
    }

    private static int tryGetCoreLogLevel() {
        return libraryIsLoaded ? Video.nativeGetCoreLogLevel() : level.ordinal();
    }

    private static void trySetCoreModuleLogLevel(int module, int level) {
        if (libraryIsLoaded) {
            Video.nativeSetModuleLevel(module, level);
        }
    }

    private static void registerConnectivityBroadcastReceiver() {
        if (applicationContext != null) {
            applicationContext.registerReceiver(connectivityChangeReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private static void unregisterConnectivityBroadcastReceiver() {
        if (applicationContext != null) {
            applicationContext.unregisterReceiver(connectivityChangeReceiver);
        }
    }

    private static native void nativeSetCoreLogLevel(int var0);

    private static native void nativeSetModuleLevel(int var0, int var1);

    private static native int nativeGetCoreLogLevel();

    static {
        connectivityChangeReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
                    if (this.isInitialStickyBroadcast()) {
                        logger.d("Ignoring network event, sticky broadcast");
                        return;
                    }
                    ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
                    NetworkInfo newNetworkInfo = conn.getActiveNetworkInfo();
                    NetworkChangeEvent networkChangeEvent = NetworkChangeEvent.CONNECTION_CHANGED;
                    if (newNetworkInfo != null && (currentNetworkInfo == null || currentNetworkInfo.getDetailedState() != newNetworkInfo.getDetailedState() || currentNetworkInfo.getType() != newNetworkInfo.getType() || currentNetworkInfo.getSubtype() != newNetworkInfo.getSubtype())) {
                        if (!newNetworkInfo.isConnectedOrConnecting()) {
                            networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                        }
                        logger.d("Network event detected: " + networkChangeEvent.name());
                        Video.onNetworkChange(networkChangeEvent);
                    } else if (newNetworkInfo == null) {
                        networkChangeEvent = NetworkChangeEvent.CONNECTION_LOST;
                        logger.d("Network connection lost");
                        Video.onNetworkChange(networkChangeEvent);
                    }
                    currentNetworkInfo = newNetworkInfo;
                }
            }
        };
    }

    static enum NetworkChangeEvent {
        CONNECTION_LOST,
        CONNECTION_CHANGED;

    }
}

