/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import com.twilio.video.AudioTrack;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.Preconditions;
import com.twilio.video.TrackPriority;

public class LocalAudioTrackPublication
implements AudioTrackPublication {
    private final String sid;
    private final LocalAudioTrack localAudioTrack;
    private TrackPriority priority;
    private long nativeLocalAudioTrackPublicationContext;

    LocalAudioTrackPublication(@NonNull String sid, @NonNull LocalAudioTrack localAudioTrack, @NonNull TrackPriority priority, long nativeLocalAudioTrackPublicationContext) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkNotNull(localAudioTrack, "Local audio track must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(priority, "priority should not be null");
        this.sid = sid;
        this.localAudioTrack = localAudioTrack;
        this.priority = priority;
        this.nativeLocalAudioTrackPublicationContext = nativeLocalAudioTrackPublicationContext;
    }

    @Override
    @NonNull
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public String getTrackName() {
        return this.localAudioTrack.getName();
    }

    @Override
    public boolean isTrackEnabled() {
        return this.localAudioTrack.isEnabled();
    }

    @Override
    @NonNull
    public AudioTrack getAudioTrack() {
        return this.localAudioTrack;
    }

    @NonNull
    public LocalAudioTrack getLocalAudioTrack() {
        return this.localAudioTrack;
    }

    @Deprecated
    @NonNull
    public TrackPriority getPriority() {
        return this.priority;
    }

    @Deprecated
    public void setPriority(TrackPriority priority) {
        this.priority = priority;
        if (!this.isReleased()) {
            this.nativeSetPriority(this.nativeLocalAudioTrackPublicationContext, priority);
        }
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalAudioTrackPublicationContext);
            this.nativeLocalAudioTrackPublicationContext = 0L;
        }
    }

    synchronized boolean isReleased() {
        return this.nativeLocalAudioTrackPublicationContext == 0L;
    }

    private native void nativeSetPriority(long var1, TrackPriority var3);

    private native void nativeRelease(long var1);
}

