/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;

public class AudioOptions {
    public final boolean echoCancellation;
    public final boolean autoGainControl;
    public final boolean noiseSuppression;
    public final boolean highpassFilter;
    public final boolean stereoSwapping;
    public final boolean audioJitterBufferFastAccelerate;
    public final boolean typingDetection;

    private AudioOptions(@NonNull Builder builder) {
        this.echoCancellation = builder.echoCancellation;
        this.autoGainControl = builder.autoGainControl;
        this.noiseSuppression = builder.noiseSuppression;
        this.highpassFilter = builder.highpassFilter;
        this.stereoSwapping = builder.stereoSwapping;
        this.audioJitterBufferFastAccelerate = builder.audioJitterBufferFastAccelerate;
        this.typingDetection = builder.typingDetection;
    }

    @NonNull
    public String toString() {
        return "AudioOptions{echoCancellation=" + this.echoCancellation + ", autoGainControl=" + this.autoGainControl + ", noiseSuppression=" + this.noiseSuppression + ", highpassFilter=" + this.highpassFilter + ", stereoSwapping=" + this.stereoSwapping + ", audioJitterBufferFastAccelerate=" + this.audioJitterBufferFastAccelerate + ", typingDetection=" + this.typingDetection + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AudioOptions)) {
            return false;
        }
        AudioOptions that = (AudioOptions)o;
        if (this.echoCancellation != that.echoCancellation) {
            return false;
        }
        if (this.autoGainControl != that.autoGainControl) {
            return false;
        }
        if (this.noiseSuppression != that.noiseSuppression) {
            return false;
        }
        if (this.highpassFilter != that.highpassFilter) {
            return false;
        }
        if (this.stereoSwapping != that.stereoSwapping) {
            return false;
        }
        if (this.audioJitterBufferFastAccelerate != that.audioJitterBufferFastAccelerate) {
            return false;
        }
        return this.typingDetection == that.typingDetection;
    }

    public int hashCode() {
        int result = this.echoCancellation ? 1 : 0;
        result = 31 * result + (this.autoGainControl ? 1 : 0);
        result = 31 * result + (this.noiseSuppression ? 1 : 0);
        result = 31 * result + (this.highpassFilter ? 1 : 0);
        result = 31 * result + (this.stereoSwapping ? 1 : 0);
        result = 31 * result + (this.audioJitterBufferFastAccelerate ? 1 : 0);
        result = 31 * result + (this.typingDetection ? 1 : 0);
        return result;
    }

    public static final class Builder {
        private boolean echoCancellation = true;
        private boolean autoGainControl = true;
        private boolean noiseSuppression = true;
        private boolean highpassFilter = true;
        private boolean stereoSwapping = false;
        private boolean audioJitterBufferFastAccelerate = false;
        private boolean typingDetection = true;

        @NonNull
        public Builder echoCancellation(boolean echoCancellation) {
            this.echoCancellation = echoCancellation;
            return this;
        }

        @NonNull
        public Builder autoGainControl(boolean autoGainControl) {
            this.autoGainControl = autoGainControl;
            return this;
        }

        @NonNull
        public Builder noiseSuppression(boolean noiseSuppression) {
            this.noiseSuppression = noiseSuppression;
            return this;
        }

        @NonNull
        public Builder highpassFilter(boolean highpassFilter) {
            this.highpassFilter = highpassFilter;
            return this;
        }

        @NonNull
        public Builder stereoSwapping(boolean stereoSwapping) {
            this.stereoSwapping = stereoSwapping;
            return this;
        }

        @NonNull
        public Builder audioJitterBufferFastAccelerate(boolean audioJitterBufferFastAccelerate) {
            this.audioJitterBufferFastAccelerate = audioJitterBufferFastAccelerate;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder typingDetection(boolean typingDetection) {
            this.typingDetection = typingDetection;
            return this;
        }

        @NonNull
        public AudioOptions build() {
            return new AudioOptions(this);
        }
    }
}

