/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import com.twilio.video.IceServer;
import com.twilio.video.IceTransportPolicy;
import java.util.HashSet;
import java.util.Set;

public class IceOptions {
    private final Set<IceServer> iceServers;
    private final IceTransportPolicy iceTransportPolicy;

    private IceOptions(Builder builder) {
        this.iceServers = builder.iceServers;
        this.iceTransportPolicy = builder.iceTransportPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IceOptions that = (IceOptions)o;
        return this.iceServers.equals(that.iceServers) && this.iceTransportPolicy == that.iceTransportPolicy;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.iceServers != null ? this.iceServers.hashCode() : 0);
        result = 31 * result + (this.iceTransportPolicy != null ? this.iceTransportPolicy.hashCode() : 0);
        return result;
    }

    @NonNull
    public Set<IceServer> getIceServers() {
        return this.iceServers;
    }

    @NonNull
    public IceTransportPolicy getIceTransportPolicy() {
        return this.iceTransportPolicy;
    }

    IceServer[] getIceServersArray() {
        IceServer[] iceServersArray = new IceServer[]{};
        if (this.iceServers != null && this.iceServers.size() > 0) {
            iceServersArray = this.iceServers.toArray(new IceServer[this.iceServers.size()]);
        }
        return iceServersArray;
    }

    public static class Builder {
        private Set<IceServer> iceServers = new HashSet<IceServer>();
        private IceTransportPolicy iceTransportPolicy = IceTransportPolicy.ALL;

        @NonNull
        public Builder iceServers(@NonNull Set<IceServer> iceServers) {
            this.iceServers = iceServers;
            return this;
        }

        @NonNull
        public Builder iceTransportPolicy(@NonNull IceTransportPolicy iceTransportPolicy) {
            this.iceTransportPolicy = iceTransportPolicy;
            return this;
        }

        @NonNull
        public IceOptions build() {
            return new IceOptions(this);
        }
    }
}

