package com.twilio.video;

import android.annotation.TargetApi;
import android.hardware.camera2.CaptureRequest;
import androidx.annotation.NonNull;

/**
 * Interface for updating the {@link android.hardware.camera2.CaptureRequest} of a {@link
 * Camera2Capturer}.
 */
@TargetApi(21)
public interface CaptureRequestUpdater {
    /**
     * Invoked when the {@link CaptureRequest} is available for modification.
     *
     * <p>The provided {@link CaptureRequest.Builder} is pre-configured with optimal settings to
     * capture video for video streaming.
     *
     * @param captureRequestBuilder the current capture request builder for the {@link
     *     android.hardware.camera2.CameraCaptureSession} associated with the {@link
     *     Camera2Capturer}.
     */
    void apply(@NonNull CaptureRequest.Builder captureRequestBuilder);
}
