package com.twilio.video;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

/** Stats report contains stats for all the media tracks that exist in peer connection. */
public class StatsReport {
    private final String peerConnectionId;
    private List<LocalAudioTrackStats> localAudioTrackStats = new ArrayList<>();
    private List<LocalVideoTrackStats> localVideoTrackStats = new ArrayList<>();
    private List<RemoteAudioTrackStats> remoteAudioTrackStats = new ArrayList<>();
    private List<RemoteVideoTrackStats> remoteVideoTrackStats = new ArrayList<>();
    private List<IceCandidatePairStats> iceCandidatePairStats = new ArrayList<>();
    private List<IceCandidateStats> iceCandidateStats = new ArrayList<>();

    StatsReport(@NonNull String peerConnectionId) {
        this.peerConnectionId = peerConnectionId;
    }

    /** Returns the id of peer connection related to this report. */
    @NonNull
    public String getPeerConnectionId() {
        return peerConnectionId;
    }

    /**
     * Returns stats for all local audio tracks in the peer connection.
     *
     * @return a list of local audio tracks stats
     */
    @NonNull
    public List<LocalAudioTrackStats> getLocalAudioTrackStats() {
        return localAudioTrackStats;
    }

    /**
     * Returns stats for all local video tracks in the peer connection.
     *
     * @return a list of local video tracks stats
     */
    @NonNull
    public List<LocalVideoTrackStats> getLocalVideoTrackStats() {
        return localVideoTrackStats;
    }

    /**
     * Returns stats for all remote audio tracks in the peer connection.
     *
     * @return a list of remote audio tracks stats
     */
    @NonNull
    public List<RemoteAudioTrackStats> getRemoteAudioTrackStats() {
        return remoteAudioTrackStats;
    }

    /**
     * Returns stats for all remote video tracks in the peer connection.
     *
     * @return a list of remote video tracks stats
     */
    @NonNull
    public List<RemoteVideoTrackStats> getRemoteVideoTrackStats() {
        return remoteVideoTrackStats;
    }

    /**
     * Returns stats for all ice candidate pairs in the peer connection.
     *
     * @return a list of ice candidate pair stats
     */
    @NonNull
    public List<IceCandidatePairStats> getIceCandidatePairStats() {
        return iceCandidatePairStats;
    }

    /**
     * Returns stats for individual ice candidates in the peer connection
     *
     * @return a list of all ice candidate stats
     */
    @NonNull
    public List<IceCandidateStats> getIceCandidateStats() {
        return iceCandidateStats;
    }

    void addIceCandidatePairStats(IceCandidatePairStats iceCandidatePairStats) {
        this.iceCandidatePairStats.add(iceCandidatePairStats);
    }

    void addIceCandidateStats(IceCandidateStats iceCandidateStats) {
        this.iceCandidateStats.add(iceCandidateStats);
    }

    void addLocalAudioTrackStats(LocalAudioTrackStats localAudioTrackStats) {
        this.localAudioTrackStats.add(localAudioTrackStats);
    }

    void addLocalVideoTrackStats(LocalVideoTrackStats localVideoTrackStats) {
        this.localVideoTrackStats.add(localVideoTrackStats);
    }

    void addAudioTrackStats(RemoteAudioTrackStats remoteAudioTrackStats) {
        this.remoteAudioTrackStats.add(remoteAudioTrackStats);
    }

    void addVideoTrackStats(RemoteVideoTrackStats remoteVideoTrackStats) {
        this.remoteVideoTrackStats.add(remoteVideoTrackStats);
    }
}
