package com.twilio.video

import android.content.Context
import android.util.DisplayMetrics
import kotlin.math.roundToInt

fun Context.convertPixelsToDp(px: Float) =
        (px / (resources.displayMetrics.densityDpi.toFloat() / DisplayMetrics.DENSITY_DEFAULT)).roundToInt()
