/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.twilio.video.AccessedByNative;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.DataTrackPublication;
import com.twilio.video.Logger;
import com.twilio.video.NetworkQualityLevel;
import com.twilio.video.Participant;
import com.twilio.video.Preconditions;
import com.twilio.video.RemoteAudioTrack;
import com.twilio.video.RemoteAudioTrackPublication;
import com.twilio.video.RemoteDataTrack;
import com.twilio.video.RemoteDataTrackPublication;
import com.twilio.video.RemoteVideoTrack;
import com.twilio.video.RemoteVideoTrackPublication;
import com.twilio.video.ThreadChecker;
import com.twilio.video.TrackPriority;
import com.twilio.video.TrackPublication;
import com.twilio.video.TwilioException;
import com.twilio.video.VideoTrackPublication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@AccessedByNative
public class RemoteParticipant
implements Participant {
    private static final Logger logger = Logger.getLogger(RemoteParticipant.class);
    private final String identity;
    private final String sid;
    private NetworkQualityLevel networkQualityLevel = NetworkQualityLevel.NETWORK_QUALITY_LEVEL_UNKNOWN;
    private final List<RemoteAudioTrackPublication> remoteAudioTrackPublications;
    private final List<AudioTrackPublication> audioTrackPublications;
    private final List<RemoteVideoTrackPublication> remoteVideoTrackPublications;
    private final List<VideoTrackPublication> videoTrackPublications;
    private final List<RemoteDataTrackPublication> remoteDataTrackPublications;
    private final List<DataTrackPublication> dataTrackPublications;
    private final Handler handler;
    private final AtomicReference<Listener> listenerReference = new AtomicReference<Object>(null);
    @AccessedByNative
    final Listener remoteParticipantListenerProxy = new Listener(){

        @Override
        @AccessedByNative
        public void onAudioTrackPublished(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackPublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackPublished");
                RemoteParticipant.this.audioTrackPublications.add(remoteAudioTrackPublication);
                RemoteParticipant.this.remoteAudioTrackPublications.add(remoteAudioTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackPublished(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackUnpublished(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackUnpublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackUnpublished");
                RemoteParticipant.this.audioTrackPublications.remove(remoteAudioTrackPublication);
                RemoteParticipant.this.remoteAudioTrackPublications.remove(remoteAudioTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackUnpublished(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackSubscribed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication, @NonNull RemoteAudioTrack remoteAudioTrack) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackSubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackSubscribed");
                remoteAudioTrackPublication.setSubscribed(true);
                remoteAudioTrackPublication.setRemoteAudioTrack(remoteAudioTrack);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackSubscribed(remoteParticipant, remoteAudioTrackPublication, remoteAudioTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackSubscriptionFailed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication, @NonNull TwilioException twilioException) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackSubscriptionFailed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackSubscriptionFailed");
                remoteAudioTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackSubscriptionFailed(remoteParticipant, remoteAudioTrackPublication, twilioException);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackUnsubscribed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication, @NonNull RemoteAudioTrack remoteAudioTrack) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackUnsubscribed");
            remoteAudioTrack.release();
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackUnsubscribed");
                remoteAudioTrackPublication.setRemoteAudioTrack(null);
                remoteAudioTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackUnsubscribed(remoteParticipant, remoteAudioTrackPublication, remoteAudioTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackPublishPriorityChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication, @NonNull TrackPriority trackPriority) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackPublishPriorityChanged");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackPublishPriorityChanged");
                remoteAudioTrackPublication.setPublishPriority(trackPriority);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackPublishPriorityChanged(remoteParticipant, remoteAudioTrackPublication, trackPriority);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackPublished(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackPublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackPublished");
                RemoteParticipant.this.videoTrackPublications.add(remoteVideoTrackPublication);
                RemoteParticipant.this.remoteVideoTrackPublications.add(remoteVideoTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackPublished(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackUnpublished(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackUnpublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackUnpublished");
                RemoteParticipant.this.videoTrackPublications.remove(remoteVideoTrackPublication);
                RemoteParticipant.this.remoteVideoTrackPublications.remove(remoteVideoTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackUnpublished(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackSubscribed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication, @NonNull RemoteVideoTrack remoteVideoTrack) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackSubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackSubscribed");
                remoteVideoTrackPublication.setSubscribed(true);
                remoteVideoTrackPublication.setRemoteVideoTrack(remoteVideoTrack);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackSubscribed(remoteParticipant, remoteVideoTrackPublication, remoteVideoTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackSubscriptionFailed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication, @NonNull TwilioException twilioException) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackSubscriptionFailed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackSubscriptionFailed");
                remoteVideoTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackSubscriptionFailed(remoteParticipant, remoteVideoTrackPublication, twilioException);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackUnsubscribed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication, @NonNull RemoteVideoTrack remoteVideoTrack) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackUnsubscribed");
            remoteVideoTrack.release();
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackUnsubscribed");
                remoteVideoTrackPublication.setRemoteVideoTrack(null);
                remoteVideoTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackUnsubscribed(remoteParticipant, remoteVideoTrackPublication, remoteVideoTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackPublishPriorityChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication, @NonNull TrackPriority trackPriority) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackPublishPriorityChanged");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackPublishPriorityChanged");
                remoteVideoTrackPublication.setPublishPriority(trackPriority);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackPublishPriorityChanged(remoteParticipant, remoteVideoTrackPublication, trackPriority);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackSwitchedOn(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrack remoteVideoTrack) {
            Preconditions.checkState(remoteParticipant != null, "Received null remote participant in onVideoTrackSwitchedOn");
            Preconditions.checkState(remoteVideoTrack != null, "Received null remote video track in onVideoTrackSwitchedOn");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackSwitchedOn");
                remoteVideoTrack.setSwitchedOff(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackSwitchedOn(remoteParticipant, remoteVideoTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackSwitchedOff(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrack remoteVideoTrack) {
            Preconditions.checkState(remoteParticipant != null, "Received null remote participant in onVideoTrackSwitchedOff");
            Preconditions.checkState(remoteVideoTrack != null, "Received null remote video track in onVideoTrackSwitchedOff");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackSwitchedOff");
                remoteVideoTrack.setSwitchedOff(true);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackSwitchedOff(remoteParticipant, remoteVideoTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onDataTrackPublished(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackPublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackPublished");
                RemoteParticipant.this.dataTrackPublications.add(remoteDataTrackPublication);
                RemoteParticipant.this.remoteDataTrackPublications.add(remoteDataTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackPublished(remoteParticipant, remoteDataTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onDataTrackUnpublished(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackUnpublished");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackUnpublished");
                RemoteParticipant.this.dataTrackPublications.remove(remoteDataTrackPublication);
                RemoteParticipant.this.remoteDataTrackPublications.remove(remoteDataTrackPublication);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackUnpublished(remoteParticipant, remoteDataTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onDataTrackSubscribed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication, @NonNull RemoteDataTrack remoteDataTrack) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackSubscribed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackSubscribed");
                remoteDataTrackPublication.setSubscribed(true);
                remoteDataTrackPublication.setRemoteDataTrack(remoteDataTrack);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackSubscribed(remoteParticipant, remoteDataTrackPublication, remoteDataTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onDataTrackSubscriptionFailed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication, @NonNull TwilioException twilioException) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackSubscriptionFailed");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackSubscriptionFailed");
                remoteDataTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackSubscriptionFailed(remoteParticipant, remoteDataTrackPublication, twilioException);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onDataTrackUnsubscribed(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication, @NonNull RemoteDataTrack remoteDataTrack) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackUnsubscribed");
            remoteDataTrack.release();
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackUnsubscribed");
                remoteDataTrackPublication.setRemoteDataTrack(null);
                remoteDataTrackPublication.setSubscribed(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackUnsubscribed(remoteParticipant, remoteDataTrackPublication, remoteDataTrack);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onDataTrackPublishPriorityChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication, @NonNull TrackPriority trackPriority) {
            this.checkCallback(remoteParticipant, remoteDataTrackPublication, "onDataTrackPublishPriorityChanged");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onDataTrackPublishPriorityChanged");
                remoteDataTrackPublication.setPublishPriority(trackPriority);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onDataTrackPublishPriorityChanged(remoteParticipant, remoteDataTrackPublication, trackPriority);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackEnabled(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackEnabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackEnabled");
                remoteAudioTrackPublication.setEnabled(true);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackEnabled(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onAudioTrackDisabled(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication) {
            this.checkCallback(remoteParticipant, remoteAudioTrackPublication, "onAudioTrackDisabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onAudioTrackDisabled");
                remoteAudioTrackPublication.setEnabled(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onAudioTrackDisabled(remoteParticipant, remoteAudioTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackEnabled(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackEnabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackEnabled");
                remoteVideoTrackPublication.setEnabled(true);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackEnabled(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onVideoTrackDisabled(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication) {
            this.checkCallback(remoteParticipant, remoteVideoTrackPublication, "onVideoTrackDisabled");
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onVideoTrackDisabled");
                remoteVideoTrackPublication.setEnabled(false);
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onVideoTrackDisabled(remoteParticipant, remoteVideoTrackPublication);
                }
            });
        }

        @Override
        @AccessedByNative
        public void onNetworkQualityLevelChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull NetworkQualityLevel networkQualityLevel) {
            RemoteParticipant.this.handler.post(() -> {
                ThreadChecker.checkIsValidThread(RemoteParticipant.this.handler);
                logger.d("onNetworkQualityLevelChanged");
                remoteParticipant.networkQualityLevel = networkQualityLevel;
                Listener listener = (Listener)RemoteParticipant.this.listenerReference.get();
                if (listener != null) {
                    listener.onNetworkQualityLevelChanged(remoteParticipant, networkQualityLevel);
                }
            });
        }

        private void checkCallback(RemoteParticipant remoteParticipant, TrackPublication trackPublication, String callback) {
            Preconditions.checkState(remoteParticipant != null, "Received null remote participant in %s", (Object)callback);
            Preconditions.checkState(trackPublication != null, "Received null track publication in %s", (Object)callback);
        }
    };
    private long nativeParticipantContext;

    @Override
    @NonNull
    public String getSid() {
        return this.sid;
    }

    @AccessedByNative
    RemoteParticipant(String identity, String sid, List<RemoteAudioTrackPublication> remoteAudioTrackPublications, List<RemoteVideoTrackPublication> remoteVideoTrackPublications, List<RemoteDataTrackPublication> remoteDataTrackPublications, Handler handler, long nativeParticipantContext) {
        this.identity = identity;
        this.sid = sid;
        this.remoteAudioTrackPublications = remoteAudioTrackPublications;
        this.audioTrackPublications = new ArrayList<AudioTrackPublication>(remoteAudioTrackPublications.size());
        this.addAudioTracks(remoteAudioTrackPublications);
        this.remoteVideoTrackPublications = remoteVideoTrackPublications;
        this.videoTrackPublications = new ArrayList<VideoTrackPublication>(remoteVideoTrackPublications.size());
        this.addVideoTracks(remoteVideoTrackPublications);
        this.remoteDataTrackPublications = remoteDataTrackPublications;
        this.dataTrackPublications = new ArrayList<DataTrackPublication>(remoteDataTrackPublications.size());
        this.addDataTracks(remoteDataTrackPublications);
        this.handler = handler;
        this.nativeParticipantContext = nativeParticipantContext;
    }

    @Override
    @NonNull
    public String getIdentity() {
        return this.identity;
    }

    @Override
    @NonNull
    public NetworkQualityLevel getNetworkQualityLevel() {
        return this.networkQualityLevel;
    }

    @Override
    @NonNull
    public List<AudioTrackPublication> getAudioTracks() {
        return Collections.unmodifiableList(this.audioTrackPublications);
    }

    @Override
    @NonNull
    public List<VideoTrackPublication> getVideoTracks() {
        return Collections.unmodifiableList(this.videoTrackPublications);
    }

    @Override
    @NonNull
    public List<DataTrackPublication> getDataTracks() {
        return Collections.unmodifiableList(this.dataTrackPublications);
    }

    public List<RemoteAudioTrackPublication> getRemoteAudioTracks() {
        return Collections.unmodifiableList(this.remoteAudioTrackPublications);
    }

    public List<RemoteVideoTrackPublication> getRemoteVideoTracks() {
        return Collections.unmodifiableList(this.remoteVideoTrackPublications);
    }

    public List<RemoteDataTrackPublication> getRemoteDataTracks() {
        return Collections.unmodifiableList(this.remoteDataTrackPublications);
    }

    public void setListener(Listener listener) {
        Preconditions.checkNotNull(listener, "Listener must not be null");
        this.listenerReference.set(listener);
    }

    public synchronized boolean isConnected() {
        if (this.isReleased()) {
            return false;
        }
        return this.nativeIsConnected(this.nativeParticipantContext);
    }

    synchronized void release() {
        if (!this.isReleased()) {
            for (RemoteAudioTrackPublication remoteAudioTrackPublication : this.remoteAudioTrackPublications) {
                RemoteAudioTrack remoteAudioTrack = remoteAudioTrackPublication.getRemoteAudioTrack();
                if (remoteAudioTrack == null) continue;
                remoteAudioTrack.release();
            }
            for (RemoteVideoTrackPublication remoteVideoTrackPublication : this.remoteVideoTrackPublications) {
                RemoteVideoTrack remoteVideoTrack = remoteVideoTrackPublication.getRemoteVideoTrack();
                if (remoteVideoTrack == null) continue;
                remoteVideoTrack.release();
            }
            this.nativeRelease(this.nativeParticipantContext);
            this.nativeParticipantContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeParticipantContext == 0L;
    }

    private void addAudioTracks(List<RemoteAudioTrackPublication> remoteAudioTracks) {
        this.audioTrackPublications.addAll(remoteAudioTracks);
    }

    private void addVideoTracks(List<RemoteVideoTrackPublication> remoteVideoTracks) {
        this.videoTrackPublications.addAll(remoteVideoTracks);
    }

    private void addDataTracks(List<RemoteDataTrackPublication> remoteDataTracks) {
        this.dataTrackPublications.addAll(remoteDataTracks);
    }

    private native boolean nativeIsConnected(long var1);

    private native void nativeRelease(long var1);

    @AccessedByNative
    public static interface Listener {
        public void onAudioTrackPublished(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2);

        public void onAudioTrackUnpublished(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2);

        public void onAudioTrackSubscribed(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2, @NonNull RemoteAudioTrack var3);

        public void onAudioTrackSubscriptionFailed(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2, @NonNull TwilioException var3);

        public void onAudioTrackUnsubscribed(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2, @NonNull RemoteAudioTrack var3);

        default public void onAudioTrackPublishPriorityChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteAudioTrackPublication remoteAudioTrackPublication, @NonNull TrackPriority trackPriority) {
        }

        public void onVideoTrackPublished(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2);

        public void onVideoTrackUnpublished(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2);

        public void onVideoTrackSubscribed(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2, @NonNull RemoteVideoTrack var3);

        public void onVideoTrackSubscriptionFailed(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2, @NonNull TwilioException var3);

        public void onVideoTrackUnsubscribed(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2, @NonNull RemoteVideoTrack var3);

        default public void onVideoTrackPublishPriorityChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrackPublication remoteVideoTrackPublication, @NonNull TrackPriority trackPriority) {
        }

        public void onDataTrackPublished(@NonNull RemoteParticipant var1, @NonNull RemoteDataTrackPublication var2);

        public void onDataTrackUnpublished(@NonNull RemoteParticipant var1, @NonNull RemoteDataTrackPublication var2);

        public void onDataTrackSubscribed(@NonNull RemoteParticipant var1, @NonNull RemoteDataTrackPublication var2, @NonNull RemoteDataTrack var3);

        public void onDataTrackSubscriptionFailed(@NonNull RemoteParticipant var1, @NonNull RemoteDataTrackPublication var2, @NonNull TwilioException var3);

        public void onDataTrackUnsubscribed(@NonNull RemoteParticipant var1, @NonNull RemoteDataTrackPublication var2, @NonNull RemoteDataTrack var3);

        default public void onDataTrackPublishPriorityChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteDataTrackPublication remoteDataTrackPublication, @NonNull TrackPriority trackPriority) {
        }

        public void onAudioTrackEnabled(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2);

        public void onAudioTrackDisabled(@NonNull RemoteParticipant var1, @NonNull RemoteAudioTrackPublication var2);

        public void onVideoTrackEnabled(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2);

        public void onVideoTrackDisabled(@NonNull RemoteParticipant var1, @NonNull RemoteVideoTrackPublication var2);

        default public void onVideoTrackSwitchedOn(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrack remoteVideoTrack) {
        }

        default public void onVideoTrackSwitchedOff(@NonNull RemoteParticipant remoteParticipant, @NonNull RemoteVideoTrack remoteVideoTrack) {
        }

        default public void onNetworkQualityLevelChanged(@NonNull RemoteParticipant remoteParticipant, @NonNull NetworkQualityLevel networkQualityLevel) {
        }
    }
}

