/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.AccessedByNative;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoTrack;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.VideoSink;
import tvi.webrtc.VideoSource;

public class LocalVideoTrack
extends VideoTrack {
    private static final Logger logger = Logger.getLogger(LocalVideoTrack.class);
    static final VideoFormat DEFAULT_VIDEO_FORMAT = new VideoFormat(VideoDimensions.VGA_VIDEO_DIMENSIONS, 30);
    private long nativeLocalVideoTrackHandle;
    private final String nativeTrackHash;
    private final tvi.webrtc.VideoCapturer videoCapturer;
    private final VideoFormat videoFormat;
    private final MediaFactory mediaFactory;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final VideoSource videoSource;

    @Nullable
    public static LocalVideoTrack create(@NonNull Context context, boolean enabled, @NonNull tvi.webrtc.VideoCapturer videoCapturer) {
        return LocalVideoTrack.create(context, enabled, videoCapturer, null, null);
    }

    @Nullable
    public static LocalVideoTrack create(@NonNull Context context, boolean enabled, @NonNull tvi.webrtc.VideoCapturer videoCapturer, @Nullable VideoFormat videoFormat) {
        return LocalVideoTrack.create(context, enabled, videoCapturer, videoFormat, null);
    }

    @Nullable
    public static LocalVideoTrack create(@NonNull Context context, boolean enabled, @NonNull tvi.webrtc.VideoCapturer videoCapturer, @Nullable String name) {
        return LocalVideoTrack.create(context, enabled, videoCapturer, null, name);
    }

    @Nullable
    public static LocalVideoTrack create(@NonNull Context context, boolean enabled, @NonNull tvi.webrtc.VideoCapturer videoCapturer, @Nullable VideoFormat videoFormat, @Nullable String name) {
        LocalVideoTrack localVideoTrack;
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(videoCapturer, "VideoCapturer must not be null");
        Object temporaryMediaFactoryOwner = new Object();
        MediaFactory mediaFactory = MediaFactory.instance(temporaryMediaFactoryOwner, context);
        if (videoFormat == null) {
            videoFormat = videoCapturer instanceof VideoCapturer ? ((VideoCapturer)videoCapturer).getCaptureFormat() : DEFAULT_VIDEO_FORMAT;
        }
        if ((localVideoTrack = mediaFactory.createVideoTrack(context, enabled, videoCapturer, videoFormat, name)) == null) {
            logger.e("Failed to create local video track");
        } else {
            localVideoTrack.videoCapturer.initialize(localVideoTrack.surfaceTextureHelper, context, localVideoTrack.videoSource.getCapturerObserver());
            localVideoTrack.videoCapturer.startCapture(videoFormat.dimensions.width, videoFormat.dimensions.height, videoFormat.framerate);
        }
        mediaFactory.release(temporaryMediaFactoryOwner);
        return localVideoTrack;
    }

    @NonNull
    public tvi.webrtc.VideoCapturer getVideoCapturer() {
        return this.videoCapturer;
    }

    @NonNull
    public VideoFormat getVideoFormat() {
        return this.videoFormat;
    }

    @NonNull
    public VideoSource getVideoSource() {
        return this.videoSource;
    }

    @Override
    public synchronized void addSink(@NonNull VideoSink videoSink) {
        Preconditions.checkState(!this.isReleased(), "Cannot add sink to video track that has been released");
        super.addSink(videoSink);
    }

    @Override
    public synchronized void removeSink(@NonNull VideoSink videoSink) {
        Preconditions.checkState(!this.isReleased(), "Cannot remove sink from video track that has been released");
        super.removeSink(videoSink);
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalVideoTrackHandle);
        }
        logger.e("Local video track is not enabled because it has been released");
        return false;
    }

    @Override
    @NonNull
    public String getName() {
        return super.getName();
    }

    public synchronized void enable(boolean enabled) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalVideoTrackHandle, enabled);
        } else {
            logger.e("Cannot enable a local video track that has been removed");
        }
    }

    @Override
    public synchronized void release() {
        if (!this.isReleased()) {
            super.release();
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                logger.e(e.getMessage(), e);
            }
            this.videoCapturer.dispose();
            this.videoSource.dispose();
            this.surfaceTextureHelper.dispose();
            this.nativeRelease(this.nativeLocalVideoTrackHandle);
            this.nativeLocalVideoTrackHandle = 0L;
            this.mediaFactory.release(this);
        }
    }

    @AccessedByNative
    LocalVideoTrack(long nativeLocalVideoTrackHandle, boolean enabled, tvi.webrtc.VideoCapturer videoCapturer, VideoFormat videoFormat, tvi.webrtc.VideoTrack webrtcVideoTrack, String nativeTrackHash, String name, Context context, SurfaceTextureHelper surfaceTextureHelper, VideoSource videoSource) {
        super(webrtcVideoTrack, enabled, name);
        this.nativeTrackHash = nativeTrackHash;
        this.nativeLocalVideoTrackHandle = nativeLocalVideoTrackHandle;
        this.videoCapturer = videoCapturer;
        this.videoFormat = videoFormat;
        this.mediaFactory = MediaFactory.instance(this, context);
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.videoSource = videoSource;
    }

    @VisibleForTesting(otherwise=5)
    long addSinkWithWants(@NonNull VideoSink videoSink, boolean rotationApplied) {
        long nativeVideoSinkHandle = this.nativeAddSinkWithWants(this.nativeLocalVideoTrackHandle, rotationApplied);
        super.addSink(videoSink);
        return nativeVideoSinkHandle;
    }

    @VisibleForTesting(otherwise=5)
    void removeSinkWithWants(long nativeVideoSinkHandle) {
        this.nativeRemoveSinkWithWants(this.nativeLocalVideoTrackHandle, nativeVideoSinkHandle);
    }

    @Override
    boolean isReleased() {
        return this.nativeLocalVideoTrackHandle == 0L;
    }

    String getNativeTrackHash() {
        return this.nativeTrackHash;
    }

    @AccessedByNative
    synchronized long getNativeHandle() {
        return this.nativeLocalVideoTrackHandle;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    @VisibleForTesting(otherwise=5)
    private native long nativeAddSinkWithWants(long var1, boolean var3);

    @VisibleForTesting(otherwise=5)
    private native void nativeRemoveSinkWithWants(long var1, long var3);

    private native void nativeRelease(long var1);
}

