/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.hardware.Camera;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.CameraCapturerFormatProvider;
import com.twilio.video.CameraParameterUpdater;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import tvi.webrtc.Camera1Capturer;
import tvi.webrtc.Camera1Session;
import tvi.webrtc.CameraEnumerationAndroid;
import tvi.webrtc.CameraVideoCapturer;
import tvi.webrtc.CapturerObserver;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.ThreadUtils;
import tvi.webrtc.VideoFrame;

public class CameraCapturer
implements VideoCapturer {
    private static final int CAMERA_CLOSED_TIMEOUT_MS = 3000;
    private static final String CAMERA_CLOSED_FAILED = "Failed to close camera";
    private static final String ERROR_MESSAGE_CAMERA_SERVER_DIED = "Camera server died!";
    private static final String ERROR_MESSAGE_UNKNOWN = "Camera error:";
    private static final Logger logger = Logger.getLogger(CameraCapturer.class);
    public static final int ERROR_CAMERA_FREEZE = 0;
    public static final int ERROR_CAMERA_SERVER_STOPPED = 1;
    public static final int ERROR_UNSUPPORTED_SOURCE = 2;
    public static final int ERROR_CAMERA_PERMISSION_NOT_GRANTED = 3;
    public static final int ERROR_CAMERA_SWITCH_FAILED = 5;
    public static final int ERROR_UNKNOWN = 6;
    private final Object stateLock = new Object();
    private State state = State.IDLE;
    private final Context context;
    private final CameraCapturerFormatProvider formatProvider;
    private final AtomicBoolean parameterUpdatePending = new AtomicBoolean(false);
    private Listener listener;
    @VisibleForTesting
    Camera1Capturer webRtcCameraCapturer;
    private CameraSource cameraSource;
    private Camera1Session camera1Session;
    private CapturerObserver capturerObserver;
    private final CapturerObserver observerAdapter = new CapturerObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStarted(boolean success) {
            CameraCapturer.this.capturerObserver.onCapturerStarted(success);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.state == State.STARTING) {
                    CameraCapturer.this.camera1Session = (Camera1Session)CameraCapturer.this.webRtcCameraCapturer.getCameraSession();
                    CameraCapturer.this.state = State.RUNNING;
                    if (CameraCapturer.this.cameraParameterUpdater != null) {
                        CameraCapturer.this.updateCameraParametersOnCameraThread(CameraCapturer.this.cameraParameterUpdater);
                        CameraCapturer.this.cameraParameterUpdater = null;
                    }
                } else {
                    logger.w("Attempted to transition from " + (Object)((Object)CameraCapturer.this.state) + " to RUNNING");
                }
            }
        }

        public void onCapturerStopped() {
            CameraCapturer.this.capturerObserver.onCapturerStopped();
        }

        public void onFrameCaptured(VideoFrame videoFrame) {
            CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
        }
    };
    private CameraParameterUpdater cameraParameterUpdater;
    private CountDownLatch cameraClosed;
    private final CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraError(String errorMsg) {
            if (CameraCapturer.this.listener != null) {
                if (errorMsg.equals(CameraCapturer.ERROR_MESSAGE_CAMERA_SERVER_DIED)) {
                    logger.e("Camera server stopped.");
                    CameraCapturer.this.listener.onError(1);
                } else if (errorMsg.contains(CameraCapturer.ERROR_MESSAGE_UNKNOWN)) {
                    logger.e("Unknown camera error occurred.");
                    CameraCapturer.this.listener.onError(6);
                }
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraFreezed(String s) {
            logger.e("Camera froze.");
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(0);
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }

        public void onCameraOpening(String message) {
        }

        public void onFirstFrameAvailable() {
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onFirstFrameAvailable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraClosed() {
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.state == State.STOPPING) {
                    CameraCapturer.this.camera1Session = null;
                    CameraCapturer.this.cameraClosed.countDown();
                }
            }
        }

        public void onCameraDisconnected() {
        }
    };
    private final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler = new CameraVideoCapturer.CameraSwitchHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchDone(boolean isFrontCamera) {
            CameraCapturer cameraCapturer = CameraCapturer.this;
            synchronized (cameraCapturer) {
                CameraCapturer.this.cameraSource = isFrontCamera ? CameraSource.FRONT_CAMERA : CameraSource.BACK_CAMERA;
            }
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onCameraSwitched();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchError(String errorMessage) {
            logger.e("Failed to switch to camera source " + (Object)((Object)CameraCapturer.this.cameraSource));
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(5);
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }
    };

    public static boolean isSourceAvailable(@NonNull CameraSource cameraSource) {
        Preconditions.checkNotNull(cameraSource, "Camera source must not be null");
        CameraCapturerFormatProvider cameraCapturerFormatProvider = new CameraCapturerFormatProvider();
        return CameraCapturer.isSourceAvailable(cameraCapturerFormatProvider, cameraSource);
    }

    static boolean isSourceAvailable(@NonNull CameraCapturerFormatProvider cameraCapturerFormatProvider, @NonNull CameraSource cameraSource) {
        return cameraCapturerFormatProvider.getCameraId(cameraSource) != -1;
    }

    public CameraCapturer(@NonNull Context context, @NonNull CameraSource cameraSource) {
        this(context, cameraSource, null);
    }

    public CameraCapturer(@NonNull Context context, @NonNull CameraSource cameraSource, @Nullable Listener listener) {
        this(context, cameraSource, listener, new CameraCapturerFormatProvider());
    }

    @VisibleForTesting(otherwise=2)
    CameraCapturer(@NonNull Context context, @NonNull CameraSource cameraSource, @Nullable Listener listener, @NonNull CameraCapturerFormatProvider formatProvider) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(cameraSource, "Camera source must not be null");
        this.context = context;
        this.cameraSource = cameraSource;
        this.listener = listener;
        this.formatProvider = formatProvider;
    }

    public boolean isScreencast() {
        return false;
    }

    public void initialize(@NonNull SurfaceTextureHelper surfaceTextureHelper, @NonNull Context context, @NonNull CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
        boolean capturerCreated = this.createWebRtcCameraCapturer();
        if (capturerCreated) {
            this.webRtcCameraCapturer.initialize(surfaceTextureHelper, context, this.observerAdapter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(int width, int height, int framerate) {
        if (this.webRtcCameraCapturer != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STARTING;
            }
            this.webRtcCameraCapturer.startCapture(width, height, framerate);
        } else {
            logger.e("Failed to startCapture");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture() {
        if (this.webRtcCameraCapturer != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STOPPING;
                this.cameraClosed = new CountDownLatch(1);
            }
            this.webRtcCameraCapturer.stopCapture();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)this.cameraClosed, (long)3000L)) {
                logger.e("Camera closed event not received");
            }
            object = this.stateLock;
            synchronized (object) {
                this.cameraClosed = null;
                this.state = State.IDLE;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.webRtcCameraCapturer != null) {
            this.webRtcCameraCapturer.dispose();
            this.webRtcCameraCapturer = null;
        }
    }

    @NonNull
    public synchronized CameraSource getCameraSource() {
        return this.cameraSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchCamera() {
        CameraSource nextCameraSource = this.cameraSource == CameraSource.FRONT_CAMERA ? CameraSource.BACK_CAMERA : CameraSource.FRONT_CAMERA;
        boolean nextCameraSourceSupported = CameraCapturer.isSourceAvailable(this.formatProvider, nextCameraSource);
        if (!nextCameraSourceSupported) {
            logger.w(String.format("Cannot switch to unsupported camera source %s", new Object[]{nextCameraSource}));
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.IDLE) {
                this.webRtcCameraCapturer.switchCamera(this.cameraSwitchHandler);
            } else {
                this.cameraSource = nextCameraSource;
                if (this.listener != null) {
                    this.listener.onCameraSwitched();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCameraParameters(@NonNull CameraParameterUpdater cameraParameterUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                if (!this.parameterUpdatePending.get()) {
                    this.parameterUpdatePending.set(true);
                    return this.webRtcCameraCapturer.getHandler().post(() -> this.updateCameraParametersOnCameraThread(cameraParameterUpdater));
                }
                logger.w("Parameters will not be applied with parameter update pending");
                return false;
            }
            logger.i("Camera capturer is not running. Parameters will be applied when camera capturer is resumed");
            this.cameraParameterUpdater = cameraParameterUpdater;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createWebRtcCameraCapturer() {
        if (!Util.permissionGranted(this.context, "android.permission.CAMERA")) {
            logger.e("CAMERA permission must be granted to start capturer");
            if (this.listener != null) {
                this.listener.onError(3);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.IDLE;
            }
            return false;
        }
        int cameraId = this.formatProvider.getCameraId(this.cameraSource);
        String deviceName = this.formatProvider.getDeviceName(cameraId);
        if (cameraId < 0 || deviceName == null) {
            logger.e("Failed to find camera source");
            if (this.listener != null) {
                this.listener.onError(2);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.IDLE;
            }
            return false;
        }
        this.webRtcCameraCapturer = new Camera1Capturer(deviceName, this.cameraEventsHandler, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCameraParametersOnCameraThread(@NonNull CameraParameterUpdater cameraParameterUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                Camera camera = this.camera1Session.getCamera();
                Camera.Parameters cameraParameters = camera.getParameters();
                logger.i("Applying camera parameters");
                cameraParameterUpdater.apply(cameraParameters);
                camera.stopPreview();
                camera.setPreviewCallbackWithBuffer(null);
                camera.setParameters(cameraParameters);
                Camera1Session.initializeCallbackBuffer((CameraEnumerationAndroid.CaptureFormat)this.camera1Session.getCaptureFormat(), (Camera)camera);
                this.camera1Session.listenForBytebufferFrames();
                camera.startPreview();
            } else {
                logger.w("Attempted to update camera parameters while camera capturer is not running");
            }
            this.parameterUpdatePending.set(false);
        }
    }

    public static interface Listener {
        public void onFirstFrameAvailable();

        public void onCameraSwitched();

        public void onError(int var1);
    }

    private static enum State {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static enum CameraSource {
        FRONT_CAMERA,
        BACK_CAMERA;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }
}

