package com.twilio.video;

import android.support.annotation.NonNull;

/** Options that can be specified when publishing a local track. */
public class LocalTrackPublicationOptions {
    @NonNull private final TrackPriority priority;

    public LocalTrackPublicationOptions() {
        this.priority = TrackPriority.STANDARD;
    }

    public LocalTrackPublicationOptions(@NonNull TrackPriority priority) {
        this.priority = priority;
    }

    /**
     * The {@link TrackPriority} to be used when publishing a local track. The default priority is
     * {@link TrackPriority#STANDARD}.
     */
    @NonNull
    public TrackPriority getPriority() {
        return priority;
    }
}
