/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import tvi.webrtc.JNINamespace;
import tvi.webrtc.MediaStreamTrack;
import tvi.webrtc.VideoRenderer;
import tvi.webrtc.VideoSink;

@JNINamespace(value="webrtc::jni")
public class VideoTrack
extends MediaStreamTrack {
    private final List<VideoRenderer> renderers = new ArrayList<VideoRenderer>();
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();

    public VideoTrack(long nativeTrack) {
        super(nativeTrack);
    }

    public void addSink(VideoSink sink) {
        long nativeSink = VideoTrack.nativeWrapSink(sink);
        this.sinks.put(sink, nativeSink);
        VideoTrack.nativeAddSink(this.nativeTrack, nativeSink);
    }

    public void removeSink(VideoSink sink) {
        long nativeSink = this.sinks.remove(sink);
        if (nativeSink != 0L) {
            VideoTrack.nativeRemoveSink(this.nativeTrack, nativeSink);
            VideoTrack.nativeFreeSink(nativeSink);
        }
    }

    public void addRenderer(VideoRenderer renderer) {
        this.renderers.add(renderer);
        VideoTrack.nativeAddSink(this.nativeTrack, renderer.nativeVideoRenderer);
    }

    public void removeRenderer(VideoRenderer renderer) {
        if (!this.renderers.remove(renderer)) {
            return;
        }
        VideoTrack.nativeRemoveSink(this.nativeTrack, renderer.nativeVideoRenderer);
        renderer.dispose();
    }

    @Override
    public void dispose() {
        for (VideoRenderer renderer : this.renderers) {
            VideoTrack.nativeRemoveSink(this.nativeTrack, renderer.nativeVideoRenderer);
            renderer.dispose();
        }
        this.renderers.clear();
        Iterator<Object> iterator = this.sinks.values().iterator();
        while (iterator.hasNext()) {
            long nativeSink = (Long)iterator.next();
            VideoTrack.nativeRemoveSink(this.nativeTrack, nativeSink);
            VideoTrack.nativeFreeSink(nativeSink);
        }
        this.sinks.clear();
        super.dispose();
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);
}

